/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.CreateResourceTypeException;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.url.ExtendedURL;

public abstract class AbstractExtendedURLResourceTypeResolver
implements ResourceTypeResolver<ExtendedURL> {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ResourceTypeResolver<String> defaultStringResourceTypeResolver;

    protected ResourceType resolve(String hintPrefix, ExtendedURL extendedURL, Map<String, Object> parameters) throws CreateResourceTypeException {
        List<String> segments = extendedURL.getSegments();
        ResourceType resourceType = this.defaultStringResourceTypeResolver.resolve((Object)segments.get(0), Collections.emptyMap());
        if (this.componentManager.hasComponent((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}), this.computeHint(hintPrefix, resourceType.getId()))) {
            extendedURL.getSegments().remove(0);
        } else if (this.componentManager.hasComponent((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}), resourceType.getId())) {
            extendedURL.getSegments().remove(0);
        } else {
            resourceType = EntityResourceReference.TYPE;
        }
        return resourceType;
    }

    private String computeHint(String hintPrefix, String type) {
        return String.format("%s/%s", hintPrefix, type);
    }
}

