/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLType;

public class AbstractXWikiURL
implements XWikiURL {
    private XWikiURLType type;
    private Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();

    public AbstractXWikiURL(XWikiURLType type) {
        this.setType(type);
    }

    @Override
    public XWikiURLType getType() {
        return this.type;
    }

    public void setType(XWikiURLType type) {
        this.type = type;
    }

    @Override
    public void addParameter(String name, String value) {
        List<String> list = this.parameters.get(name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (value != null) {
            list.add(value);
        }
        this.parameters.put(name, list);
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public String getParameterValue(String name) {
        String result = null;
        List<String> list = this.parameters.get(name);
        if (list != null) {
            result = list.get(0);
        }
        return result;
    }
}

