/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.resource.ResourceCreationException;

public class ExtendedURL
implements Cloneable {
    private static final String URL_SEPARATOR = "/";
    private URI uri;
    private List<String> segments;

    public ExtendedURL(URL url) throws ResourceCreationException {
        this(url, null);
    }

    public ExtendedURL(URL url, String ignorePrefix) throws ResourceCreationException {
        URI internalURI;
        try {
            internalURI = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ResourceCreationException(String.format("Invalid URL [%s]", url), (Throwable)e);
        }
        this.uri = internalURI;
        String rawPath = this.getURI().getRawPath();
        if (!StringUtils.isEmpty((CharSequence)ignorePrefix)) {
            String normalizedIgnorePrefix = ignorePrefix;
            if (!ignorePrefix.startsWith(URL_SEPARATOR)) {
                normalizedIgnorePrefix = URL_SEPARATOR + ignorePrefix;
            }
            if (!this.getURI().getPath().startsWith(normalizedIgnorePrefix)) {
                throw new ResourceCreationException(String.format("URL Path [%s] doesn't start with [%s]", this.getURI().getPath(), ignorePrefix));
            }
            rawPath = rawPath.substring(ignorePrefix.length() + 1);
        }
        rawPath = StringUtils.removeStart((String)rawPath, (String)URL_SEPARATOR);
        this.segments = this.extractPathSegments(rawPath);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public URI getURI() {
        return this.uri;
    }

    private List<String> extractPathSegments(String rawPath) {
        ArrayList<String> urlSegments = new ArrayList<String>();
        for (String pathSegment : rawPath.split(URL_SEPARATOR, -1)) {
            String decodedPathSegment;
            String normalizedPathSegment = pathSegment.split(";", 2)[0];
            try {
                decodedPathSegment = URLDecoder.decode(normalizedPathSegment, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("Failed to URL decode [%s] using UTF-8.", normalizedPathSegment), e);
            }
            urlSegments.add(decodedPathSegment);
        }
        return urlSegments;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 7).append((Object)this.getURI()).append(this.getSegments()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ExtendedURL rhs = (ExtendedURL)object;
        return new EqualsBuilder().append((Object)this.getURI(), (Object)rhs.getURI()).append(this.getSegments(), rhs.getSegments()).isEquals();
    }
}

