/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultResourceReferenceResolver
implements ResourceReferenceResolver<URL> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ResourceReference resolve(URL urlRepresentation, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        ResourceReferenceResolver resolver;
        try {
            resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)ResourceReferenceResolver.TYPE_URL, this.configuration.getURLFormatId());
        }
        catch (ComponentLookupException e) {
            throw new CreateResourceReferenceException(String.format("Invalid configuration hint [%s]. Cannot create Resource Reference for [%s].", this.configuration.getURLFormatId(), urlRepresentation), (Throwable)e);
        }
        return resolver.resolve((Object)urlRepresentation, parameters);
    }
}

