/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.container;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Named(value="contextpath")
@Singleton
public class ExtendedURLURLNormalizer
implements URLNormalizer<ExtendedURL> {
    private static final String URL_SEGMENT_DELIMITER = "/";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    private Environment environment;

    public ExtendedURL normalize(ExtendedURL partialURL) {
        String contextPath = StringUtils.strip((String)this.getContextPath(), (String)URL_SEGMENT_DELIMITER);
        if (contextPath == null) {
            throw new RuntimeException(String.format("Failed to normalize the URL [%s] since the application's Servlet context couldn't be computed.", partialURL));
        }
        ArrayList<String> segments = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            segments.add(contextPath);
        }
        segments.addAll(partialURL.getSegments());
        return new ExtendedURL(segments, partialURL.getParameters());
    }

    private String getContextPath() {
        String contextPath = this.getContextPathFromConfiguration();
        if (contextPath == null) {
            contextPath = this.getContextPathFromApplicationContext();
        }
        return contextPath;
    }

    private String getContextPathFromConfiguration() {
        return (String)this.configurationSource.getProperty("xwiki.webapppath");
    }

    private String getContextPathFromApplicationContext() {
        if (this.environment instanceof ServletEnvironment) {
            return ((ServletEnvironment)this.environment).getServletContext().getContextPath();
        }
        return null;
    }
}

