/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.XWikiEntityURL;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.standard.XWikiURLBuilder;

@Component
@Named(value="entity")
@Singleton
public class EntityXWikiURLBuilder
implements XWikiURLBuilder {
    @Inject
    @Named(value="default/reference")
    private EntityReferenceResolver<EntityReference> defaultReferenceEntityReferenceResolver;

    @Override
    public XWikiURL build(WikiReference wikiReference, List<String> pathSegments) {
        String spaceName = null;
        String pageName = null;
        String attachmentName = null;
        String action = "view";
        if (pathSegments.size() == 1) {
            pageName = pathSegments.get(0);
        } else if (pathSegments.size() == 2) {
            spaceName = pathSegments.get(0);
            pageName = pathSegments.get(1);
        } else if (pathSegments.size() >= 3) {
            action = pathSegments.get(0);
            spaceName = pathSegments.get(1);
            pageName = pathSegments.get(2);
            if (action.equals("download") && pathSegments.size() >= 4) {
                attachmentName = pathSegments.get(3);
            }
        }
        WikiReference reference = wikiReference;
        EntityType entityType = EntityType.DOCUMENT;
        if (!StringUtils.isEmpty((CharSequence)spaceName)) {
            reference = new EntityReference(spaceName, EntityType.SPACE, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)pageName)) {
            reference = new EntityReference(pageName, EntityType.DOCUMENT, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty(attachmentName)) {
            reference = new EntityReference(attachmentName, EntityType.ATTACHMENT, (EntityReference)reference);
            entityType = EntityType.ATTACHMENT;
        }
        reference = this.defaultReferenceEntityReferenceResolver.resolve((Object)reference, entityType, new Object[0]);
        XWikiEntityURL entityURL = new XWikiEntityURL((EntityReference)reference);
        entityURL.setAction(action);
        return entityURL;
    }
}

