/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.filesystem;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class FilesystemExportContext {
    private Stack<Integer> cssParentDepth = new Stack();
    private Set<String> exportedPages = new HashSet<String>();
    private File exportDir;
    private Set<String> neededSkins = new HashSet<String>();
    private Set<String> exportedSkinFiles = new HashSet<String>();

    public int getCSSParentLevel() {
        return this.cssParentDepth.isEmpty() ? 0 : this.cssParentDepth.peek();
    }

    public void pushCSSParentLevels(int depth) {
        this.cssParentDepth.push(depth);
    }

    public void popCSSParentLevels() {
        this.cssParentDepth.pop();
    }

    public Set<String> getNeededSkins() {
        return this.neededSkins;
    }

    public void addNeededSkin(String skin) {
        this.neededSkins.add(skin);
    }

    public File getExportDir() {
        return this.exportDir;
    }

    public Set<String> getExportedPages() {
        return this.exportedPages;
    }

    public void addExportedPage(String page) {
        this.exportedPages.add(page);
    }

    public boolean hasExportedPage(String page) {
        return this.exportedPages.contains(page);
    }

    public void setExportDir(File exportDir) {
        this.exportDir = exportDir;
    }

    public Collection<String> getExportedSkinFiles() {
        return this.exportedSkinFiles;
    }

    public boolean hasExportedSkinFile(String filePath) {
        return this.exportedSkinFiles.contains(filePath);
    }

    public void addExportedSkinFile(String filePath) {
        this.exportedSkinFiles.add(filePath);
    }
}

