/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.reference;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="reference/entity")
@Singleton
public class EntityResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    private static final String ACTION_VIEW = "view";
    private static final String ACTION_EXPORT = "export";
    @Inject
    private EntityReferenceResolver<String> defaultEntityReferenceResolver;

    public EntityResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        String entityReferenceAsString;
        EntityType entityType;
        List pathSegments = extendedURL.getSegments();
        String action = ACTION_VIEW;
        if (pathSegments.size() == 3) {
            action = (String)pathSegments.get(0);
            entityType = this.computeEntityType((String)pathSegments.get(1));
            entityReferenceAsString = (String)pathSegments.get(2);
        } else if (pathSegments.size() == 2) {
            action = (String)pathSegments.get(0);
            entityType = this.computeDefaultEntityType(action);
            entityReferenceAsString = (String)pathSegments.get(1);
        } else if (pathSegments.size() == 1) {
            entityType = this.computeDefaultEntityType(action);
            entityReferenceAsString = (String)pathSegments.get(0);
        } else {
            throw new CreateResourceReferenceException(String.format("Invalid Entity URL [%s]", extendedURL.serialize()));
        }
        EntityResourceReference entityURL = new EntityResourceReference(this.defaultEntityReferenceResolver.resolve((Object)entityReferenceAsString, entityType, new Object[0]), EntityResourceAction.fromString((String)action));
        return entityURL;
    }

    private EntityType computeEntityType(String entityType) throws CreateResourceReferenceException {
        EntityType type;
        if (entityType.equals("page")) {
            type = EntityType.DOCUMENT;
        } else if (entityType.equals("attach")) {
            type = EntityType.ATTACHMENT;
        } else {
            throw new CreateResourceReferenceException(String.format("Unknown Entity type [%s]", entityType));
        }
        return type;
    }

    private EntityType computeDefaultEntityType(String action) throws CreateResourceReferenceException {
        EntityType type;
        if (action.equals(ACTION_VIEW)) {
            type = EntityType.DOCUMENT;
        } else if (action.equals(ACTION_EXPORT)) {
            type = EntityType.ATTACHMENT;
        } else {
            throw new CreateResourceReferenceException(String.format("Unknown Entity type for [%s]", action));
        }
        return type;
    }
}

