/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.internal.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiNotFoundBehavior;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiReferenceExtractor
implements WikiReferenceExtractor {
    @Inject
    private StandardURLConfiguration configuration;
    @Inject
    private EntityReferenceValueProvider entityReferenceValueProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public Pair<WikiReference, Boolean> extract(ExtendedURL url) {
        List segments;
        boolean isActuallyPathBased = false;
        String wikiId = null;
        if (this.configuration.isPathBasedMultiWiki() && ((String)(segments = url.getSegments()).get(0)).equalsIgnoreCase(this.configuration.getWikiPathPrefix())) {
            wikiId = this.resolvePathBasedWikiReference((String)segments.get(1));
            isActuallyPathBased = true;
        }
        if (wikiId == null) {
            wikiId = this.resolveDomainBasedWikiReference(url.getURI().getHost());
        }
        if (StringUtils.isEmpty(wikiId)) {
            wikiId = this.getMainWikiId();
        }
        return new ImmutablePair((Object)new WikiReference(wikiId.toLowerCase()), (Object)isActuallyPathBased);
    }

    private String resolvePathBasedWikiReference(String alias) {
        WikiDescriptor wikiDescriptor = this.getWikiDescriptorByAlias(alias);
        String wikiId = wikiDescriptor != null ? wikiDescriptor.getId() : this.normalizeWikiIdForNonExistentWikiDescriptor(alias);
        return wikiId;
    }

    private String resolveDomainBasedWikiReference(String alias) {
        String domainAlias;
        WikiDescriptor wikiDescriptor = this.getWikiDescriptorByAlias(alias);
        String wikiId = wikiDescriptor != null ? wikiDescriptor.getId() : ("www".equals(domainAlias = StringUtils.substringBefore((String)alias, (String)".")) || "localhost".equals(alias) || alias.matches("[0-9]{1,3}(?:\\.[0-9]{1,3}){3}") ? this.getMainWikiId() : this.normalizeWikiIdForNonExistentWikiDescriptor(domainAlias));
        return wikiId;
    }

    private String normalizeWikiIdForNonExistentWikiDescriptor(String wikiId) {
        String normalizedWikiId = wikiId;
        String mainWiki = this.getMainWikiId();
        if (!mainWiki.equals(normalizedWikiId) && this.configuration.getWikiNotFoundBehavior() == WikiNotFoundBehavior.REDIRECT_TO_MAIN_WIKI && this.getWikiDescriptorById(normalizedWikiId) == null) {
            normalizedWikiId = mainWiki;
        }
        return normalizedWikiId;
    }

    private WikiDescriptor getWikiDescriptorByAlias(String alias) {
        try {
            return this.wikiDescriptorManager.getByAlias(alias);
        }
        catch (WikiManagerException e) {
            throw new RuntimeException(String.format("Failed to located wiki descriptor for alias [%s]", alias), e);
        }
    }

    private WikiDescriptor getWikiDescriptorById(String wikiId) {
        try {
            return this.wikiDescriptorManager.getById(wikiId);
        }
        catch (WikiManagerException e) {
            throw new RuntimeException(String.format("Failed to located wiki descriptor for wiki [%s]", wikiId), e);
        }
    }

    private String getMainWikiId() {
        return this.entityReferenceValueProvider.getDefaultValue(EntityType.WIKI);
    }
}

