/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.EntityResource;
import org.xwiki.resource.ResourceCreationException;
import org.xwiki.resource.ResourceFactory;
import org.xwiki.resource.UnsupportedResourceException;
import org.xwiki.url.internal.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;

@Component
@Named(value="standard")
@Singleton
public class ExtendedURLEntityResourceFactory
implements ResourceFactory<ExtendedURL, EntityResource> {
    @Inject
    private WikiReferenceExtractor wikiExtractor;
    @Inject
    private EntityReferenceResolver<EntityReference> defaultReferenceEntityReferenceResolver;
    @Inject
    private StandardURLConfiguration configuration;

    public EntityResource createResource(ExtendedURL url, Map<String, Object> parameters) throws ResourceCreationException, UnsupportedResourceException {
        Pair<WikiReference, Boolean> extractionResult = this.wikiExtractor.extract(url);
        WikiReference wikiReference = (WikiReference)extractionResult.getLeft();
        boolean isActuallyPathBased = (Boolean)extractionResult.getRight();
        this.normalizeSegments(url, isActuallyPathBased);
        List pathSegments = url.getSegments();
        String spaceName = null;
        String pageName = null;
        String attachmentName = null;
        String action = "view";
        if (pathSegments.size() == 1) {
            pageName = (String)pathSegments.get(0);
        } else if (pathSegments.size() == 2) {
            spaceName = (String)pathSegments.get(0);
            pageName = (String)pathSegments.get(1);
        } else if (pathSegments.size() >= 3) {
            action = (String)pathSegments.get(0);
            spaceName = (String)pathSegments.get(1);
            pageName = (String)pathSegments.get(2);
            if (action.equals("download") && pathSegments.size() >= 4) {
                attachmentName = (String)pathSegments.get(3);
            }
        }
        EntityResource entityURL = new EntityResource(this.buildEntityReference(wikiReference, spaceName, pageName, attachmentName));
        entityURL.setAction(action);
        this.copyParameters(url, entityURL);
        return entityURL;
    }

    private EntityReference buildEntityReference(WikiReference wikiReference, String spaceName, String pageName, String attachmentName) {
        WikiReference reference = wikiReference;
        EntityType entityType = EntityType.DOCUMENT;
        if (!StringUtils.isEmpty((CharSequence)spaceName)) {
            reference = new EntityReference(spaceName, EntityType.SPACE, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)pageName)) {
            reference = new EntityReference(pageName, EntityType.DOCUMENT, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)attachmentName)) {
            reference = new EntityReference(attachmentName, EntityType.ATTACHMENT, (EntityReference)reference);
            entityType = EntityType.ATTACHMENT;
        }
        return this.defaultReferenceEntityReferenceResolver.resolve((Object)reference, entityType, new Object[0]);
    }

    private void normalizeSegments(ExtendedURL url, boolean isActuallyPathBased) {
        if (isActuallyPathBased) {
            url.getSegments().remove(0);
            url.getSegments().remove(0);
        } else {
            String entityPathPrefix = this.configuration.getEntityPathPrefix();
            String firstSegment = (String)url.getSegments().get(0);
            if (firstSegment.equals(entityPathPrefix) || firstSegment.equals("bin")) {
                url.getSegments().remove(0);
            }
        }
    }

    private void copyParameters(ExtendedURL source, EntityResource target) {
        if (source.getURI().getQuery() != null) {
            for (String nameValue : Arrays.asList(source.getURI().getQuery().split("&"))) {
                String[] pair = nameValue.split("=", 2);
                if (pair.length == 2) {
                    target.addParameter(pair[0], pair[1]);
                    continue;
                }
                target.addParameter(pair[0], null);
            }
        }
    }
}

