/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.EntityResource;
import org.xwiki.resource.Resource;
import org.xwiki.resource.ResourceCreationException;
import org.xwiki.resource.ResourceFactory;
import org.xwiki.resource.UnsupportedResourceException;
import org.xwiki.url.internal.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;

@Component
@Named(value="standard")
@Singleton
public class StandardResourceFactory
implements ResourceFactory<URL, Resource> {
    private static final String IGNORE_PREFIX_KEY = "ignorePrefix";
    @Inject
    @Named(value="standard")
    private ResourceFactory<ExtendedURL, EntityResource> entityResourceFactory;
    @Inject
    private StandardURLConfiguration configuration;

    public Resource createResource(URL url, Map<String, Object> parameters) throws ResourceCreationException, UnsupportedResourceException {
        String ignorePrefix = (String)parameters.get(IGNORE_PREFIX_KEY);
        ExtendedURL extendedURL = new ExtendedURL(url, ignorePrefix);
        Resource resource = this.entityResourceFactory.createResource((Object)extendedURL, parameters);
        return resource;
    }
}

