/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.standard.AbstractWikiReferenceExtractor;
import org.xwiki.wiki.descriptor.WikiDescriptor;

@Component
@Named(value="domain")
@Singleton
public class DomainWikiReferenceExtractor
extends AbstractWikiReferenceExtractor {
    @Override
    public WikiReference extract(ExtendedURL url) {
        String wikiId = this.resolveDomainBasedWikiReference(url.getURI().getHost());
        if (StringUtils.isEmpty((CharSequence)wikiId)) {
            wikiId = this.getMainWikiId();
        }
        return new WikiReference(wikiId.toLowerCase());
    }

    private String resolveDomainBasedWikiReference(String alias) {
        String domainAlias;
        WikiDescriptor wikiDescriptor = this.getWikiDescriptorByAlias(alias);
        String wikiId = wikiDescriptor != null ? wikiDescriptor.getId() : ("www".equals(domainAlias = StringUtils.substringBefore((String)alias, (String)".")) || "localhost".equals(alias) || alias.matches("[0-9]{1,3}(?:\\.[0-9]{1,3}){3}") ? this.getMainWikiId() : this.normalizeWikiIdForNonExistentWikiDescriptor(domainAlias));
        return wikiId;
    }
}

