/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="standard")
@Singleton
public class StandardExtendedURLResourceReferenceSerializer
implements ResourceReferenceSerializer<ResourceReference, ExtendedURL> {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ExtendedURL serialize(ResourceReference reference) throws UnsupportedResourceReferenceException {
        ResourceReferenceSerializer serializer;
        try {
            serializer = (ResourceReferenceSerializer)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{reference.getClass(), ExtendedURL.class}), String.format("standard/%s", reference.getType().getId()));
        }
        catch (ComponentLookupException e) {
            try {
                serializer = (ResourceReferenceSerializer)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{reference.getClass(), ExtendedURL.class}), reference.getType().getId());
            }
            catch (ComponentLookupException cle) {
                throw new UnsupportedResourceReferenceException(String.format("Failed to find serializer for Resource Reference [%s]", new Object[]{reference, cle}));
            }
        }
        return (ExtendedURL)serializer.serialize(reference);
    }
}

