/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.user.internal;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.user.UserConfiguration;

/**
 * Finds the default User Reference Resolver based on the configured User store hint.
 *
 * @version $Id: ce0a63ab213c45902775cf13df2aac623e200f60 $
 * @since 12.2
 */
@Component
@Singleton
public class DefaultConfiguredStringUserReferenceResolver extends AbstractConfiguredStringUserReferenceResolver
{
    @Inject
    private UserConfiguration userConfiguration;

    @Override
    protected String getUserReferenceResolverHint()
    {
        return this.userConfiguration.getStoreHint();
    }
}
