/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.user.UserConfiguration;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class ConfiguredStringUserReferenceSerializer
implements UserReferenceSerializer<String> {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private UserConfiguration userConfiguration;

    public String serialize(UserReference userReference) {
        return (String)this.resolveUserReferenceSerializer().serialize(userReference);
    }

    private UserReferenceSerializer<String> resolveUserReferenceSerializer() {
        DefaultParameterizedType type = new DefaultParameterizedType(null, UserReferenceSerializer.class, new Type[]{String.class});
        try {
            return (UserReferenceSerializer)this.componentManager.getInstance((Type)type, this.userConfiguration.getStoreHint());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(String.format("Failed to find user reference serializer for role [%s] and hint [%s]", type, this.userConfiguration.getStoreHint()), e);
        }
    }
}

