/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="document")
@Singleton
public class DocumentStringUserReferenceSerializer
implements UserReferenceSerializer<String> {
    private static final String SUPERADMIN_REFERENCE_STRING = "XWiki.superadmin";
    private static final String GUEST_REFERENCE_STRING = "XWiki.XWikiGuest";
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceUserReferenceResolver;

    public String serialize(UserReference userReference) {
        UserReference resolvedUserReference;
        String result = userReference == null ? null : (SuperAdminUserReference.INSTANCE == userReference ? SUPERADMIN_REFERENCE_STRING : (GuestUserReference.INSTANCE == userReference ? GUEST_REFERENCE_STRING : (CurrentUserReference.INSTANCE == userReference ? (GuestUserReference.INSTANCE == (resolvedUserReference = this.currentUserReferenceUserReferenceResolver.resolve(null, new Object[0])) ? GUEST_REFERENCE_STRING : this.serializeInternal(resolvedUserReference)) : this.serializeInternal(userReference))));
        return result;
    }

    private String serializeInternal(UserReference userReference) {
        if (!(userReference instanceof DocumentUserReference)) {
            throw new IllegalArgumentException("Only DocumentUserReference are handled");
        }
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        String result = (String)this.entityReferenceSerializer.serialize((EntityReference)documentUserReference.getReference(), new Object[0]);
        return result;
    }
}

