/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="org.xwiki.user.internal.document.DocumentUserReference")
@Singleton
public class DocumentUserManager
implements UserManager {
    private static final LocalDocumentReference USERS_XCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;

    public boolean exists(UserReference userReference) {
        boolean result;
        XWikiContext xcontext = (XWikiContext)this.xwikiContextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        DocumentReference userDocumentReference = ((DocumentUserReference)userReference).getReference();
        try {
            XWikiDocument document = xwiki.getDocument(userDocumentReference, xcontext);
            result = !document.isNew() && document.getXObject((EntityReference)USERS_XCLASS_REFERENCE) != null;
        }
        catch (Exception e) {
            this.logger.warn(String.format("Failed to check if document [%s] holds an XWiki user or not. Considering it's not the case. Root error: [%s]", userDocumentReference, ExceptionUtils.getRootCauseMessage((Throwable)e)));
            result = false;
        }
        return result;
    }
}

