/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.vfs.VfsException;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Singleton
public class DefaultVfsPermissionChecker
implements VfsPermissionChecker {
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public void checkPermission(VfsResourceReference resourceReference) throws VfsException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getUserReference(), null)) {
            throw new VfsException(String.format("Current logged-in user ([%s]) needs to have Programming Rights to use the [%s] VFS", xcontext.getUserReference(), resourceReference.getURI().getScheme()));
        }
    }
}

