/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Named(value="vfs")
@Singleton
public class VfsResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> referenceResolver;

    public VfsResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        URI vfsUri;
        List segments = extendedURL.getSegments();
        try {
            vfsUri = new URI((String)segments.get(0));
        }
        catch (URISyntaxException e) {
            throw new CreateResourceReferenceException(String.format("Invalid VFS URI [%s] for URL [%s]", segments.get(0), extendedURL));
        }
        ArrayList<String> vfsPathSegments = new ArrayList<String>(segments);
        vfsPathSegments.remove(0);
        VfsResourceReference vfsReference = new VfsResourceReference(vfsUri, vfsPathSegments);
        this.copyParameters(extendedURL, (ResourceReference)vfsReference);
        return vfsReference;
    }
}

