/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.lang.reflect.Type;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.vfs.VfsResourceReference;
import org.xwiki.vfs.internal.AbstractVfsResourceReferenceSerializer;

@Component
@Singleton
public class VfsResourceReferenceSerializer
extends AbstractVfsResourceReferenceSerializer {
    private static final Type TYPE = new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{VfsResourceReference.class, ExtendedURL.class});
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public ExtendedURL serialize(VfsResourceReference resourceReference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ExtendedURL extendedURL;
        URI uri = resourceReference.getURI();
        try {
            ResourceReferenceSerializer schemeSpecificSerializer = (ResourceReferenceSerializer)((ComponentManager)this.componentManagerProvider.get()).getInstance(TYPE, uri.getScheme());
            extendedURL = (ExtendedURL)schemeSpecificSerializer.serialize((ResourceReference)resourceReference);
        }
        catch (ComponentLookupException e) {
            extendedURL = super.serialize(resourceReference);
        }
        return extendedURL;
    }

    @Override
    protected URI makeAbsolute(URI uri) {
        return uri;
    }
}

