/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.script;

import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.java.truevfs.access.TPath;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Singleton
public class PathConverter
extends AbstractConverter<Path> {
    @Inject
    @Named(value="cascading")
    private VfsPermissionChecker permissionChecker;
    @Inject
    @Named(value="truevfs")
    private ResourceReferenceSerializer<VfsResourceReference, URI> trueVfsResourceReferenceSerializer;

    protected Path convertToType(Type targetType, Object value) {
        TPath path;
        if (value == null) {
            return null;
        }
        try {
            VfsResourceReference reference = new VfsResourceReference(new URI(value.toString()));
            this.permissionChecker.checkPermission(reference);
            URI trueVfsURI = (URI)this.trueVfsResourceReferenceSerializer.serialize((ResourceReference)reference);
            path = new TPath(trueVfsURI);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Failed to convert [%s] to a Path object", value), (Throwable)e);
        }
        return path;
    }
}

