/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Singleton
public class WebjarsResourceReferenceSerializer
implements ResourceReferenceSerializer<WebJarsResourceReference, ExtendedURL> {
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> extendedURLNormalizer;

    public ExtendedURL serialize(WebJarsResourceReference resourceReference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("webjars");
        segments.addAll(resourceReference.getResourceSegments());
        ExtendedURL extendedURL = new ExtendedURL(segments, resourceReference.getParameters());
        return (ExtendedURL)this.extendedURLNormalizer.normalize(extendedURL);
    }
}

