/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.webjars.internal.ContextInitializer;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultContextInitializer
implements ContextInitializer {
    @Inject
    private Execution execution;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public void initialize(String wikiId) throws ResourceReferenceHandlerException {
        ExecutionContext context = this.execution.getContext();
        try {
            XWikiContext xwikiContext = (XWikiContext)context.getProperty("xwikicontext");
            String normalizedWikiId = wikiId;
            if (StringUtils.isEmpty((CharSequence)wikiId)) {
                normalizedWikiId = this.wikiDescriptorManager.getMainWikiId();
            }
            xwikiContext.setWikiId(normalizedWikiId);
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException("Failed to initialize WebJars Handler's Execution Context", (Throwable)e);
        }
    }
}

