/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String UTF8 = "UTF-8";
    private static final long CACHE_DURATION = 31536000000L;
    @Inject
    private Logger logger;
    @Inject
    private Container container;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private ClassLoaderManager classLoaderManager;
    private Tika tika = new Tika();

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(WebJarsResourceReference.TYPE);
    }

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        WebJarsResourceReference webJarsResourceReference = (WebJarsResourceReference)resourceReference;
        if (!this.shouldBrowserUseCachedContent(webJarsResourceReference)) {
            InputStream resourceStream = this.getResourceStream(webJarsResourceReference);
            if (resourceStream != null) {
                try {
                    this.serveResource(webJarsResourceReference, resourceStream);
                }
                catch (ResourceReferenceHandlerException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.sendError(500, e.getMessage(), new Object[0]);
                }
            } else {
                this.sendError(404, "Resource not found [%s].", this.getResourceName(webJarsResourceReference));
            }
        }
        chain.handleNext((ResourceReference)webJarsResourceReference);
    }

    private boolean shouldBrowserUseCachedContent(WebJarsResourceReference resourceReference) {
        Response response;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && !this.shouldEvaluateResource(resourceReference) && ((ServletRequest)request).getHttpServletRequest().getHeader("If-Modified-Since") != null && (response = this.container.getResponse()) instanceof ServletResponse) {
            ((ServletResponse)response).getHttpServletResponse().setStatus(304);
            return true;
        }
        return false;
    }

    private InputStream getResourceStream(WebJarsResourceReference resourceReference) {
        String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, this.getResourceName(resourceReference));
        return this.getClassLoader(resourceReference.getNamespace()).getResourceAsStream(resourcePath);
    }

    private String getResourceName(WebJarsResourceReference resourceReference) {
        return resourceReference.getResourceName();
    }

    protected ClassLoader getClassLoader(String namespace) {
        return this.classLoaderManager.getURLClassLoader(namespace, true);
    }

    private void serveResource(WebJarsResourceReference resourceReference, InputStream rawResourceStream) throws ResourceReferenceHandlerException {
        InputStream resourceStream = rawResourceStream;
        String resourceName = this.getResourceName(resourceReference);
        if (this.shouldEvaluateResource(resourceReference)) {
            resourceStream = this.evaluate(resourceName, resourceStream);
        }
        if (!resourceStream.markSupported()) {
            resourceStream = new BufferedInputStream(resourceStream);
        }
        try {
            Response response = this.container.getResponse();
            this.setResponseHeaders(response, resourceReference);
            response.setContentType(this.tika.detect(resourceStream, resourceName));
            IOUtils.copy((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    private boolean shouldEvaluateResource(WebJarsResourceReference resourceReference) {
        return Boolean.valueOf(resourceReference.getParameterValue("evaluate"));
    }

    private InputStream evaluate(String resourceName, InputStream resourceStream) throws ResourceReferenceHandlerException {
        try {
            StringWriter writer = new StringWriter();
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, resourceName, (Reader)new InputStreamReader(resourceStream, UTF8));
            return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to evaluate the Velocity code from WebJar resource [%s]", resourceName), (Throwable)e);
        }
    }

    private void setResponseHeaders(Response response, WebJarsResourceReference resourceReference) {
        if (response instanceof ServletResponse && !this.shouldEvaluateResource(resourceReference)) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setHeader("Cache-Control", "public");
            httpResponse.setDateHeader("Expires", new Date().getTime() + 31536000000L);
            httpResponse.setDateHeader("Last-Modified", new Date().getTime());
        }
    }

    private void sendError(int statusCode, String message, Object ... parameters) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        if (response instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            try {
                httpResponse.sendError(statusCode, String.format(message, parameters));
            }
            catch (IOException e) {
                throw new ResourceReferenceHandlerException(String.format("Failed to return status code [%s].", statusCode), (Throwable)e);
            }
        }
    }
}

