/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.context.Context;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.servlet.AbstractServletResourceReferenceHandler;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractServletResourceReferenceHandler<WebJarsResourceReference> {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String UTF8 = "UTF-8";
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private ClassLoaderManager classLoaderManager;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(WebJarsResourceReference.TYPE);
    }

    protected InputStream getResourceStream(WebJarsResourceReference resourceReference) {
        String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, this.getResourceName(resourceReference));
        return this.getClassLoader(resourceReference.getNamespace()).getResourceAsStream(resourcePath);
    }

    protected String getResourceName(WebJarsResourceReference resourceReference) {
        return resourceReference.getResourceName();
    }

    protected boolean isResourceCacheable(WebJarsResourceReference resourceReference) {
        return Boolean.valueOf(resourceReference.getParameterValue("evaluate")) == false;
    }

    protected InputStream filterResource(WebJarsResourceReference resourceReference, InputStream resourceStream) throws ResourceReferenceHandlerException {
        if (!this.isResourceCacheable(resourceReference)) {
            String resourceName = this.getResourceName(resourceReference);
            try {
                StringWriter writer = new StringWriter();
                this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, resourceName, (Reader)new InputStreamReader(resourceStream, UTF8));
                return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
            }
            catch (Exception e) {
                throw new ResourceReferenceHandlerException(String.format("Failed to evaluate the Velocity code from WebJar resource [%s]", resourceName), (Throwable)e);
            }
        }
        return super.filterResource((ResourceReference)resourceReference, resourceStream);
    }

    protected ClassLoader getClassLoader(String namespace) {
        return this.classLoaderManager.getURLClassLoader(namespace, true);
    }
}

