/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.ExportURLFactoryActionHandler;
import com.xpn.xwiki.web.ExportURLFactoryContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="webjars")
public class WebJarsExportURLFactoryActionHandler
implements ExportURLFactoryActionHandler {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String WEBJAR_PATH = "webjars/";

    public URL createURL(String web, String name, String querystring, String anchor, String wikiId, XWikiContext context, ExportURLFactoryContext factoryContext) throws Exception {
        String resourceName = StringUtils.substringAfter((String)querystring, (String)"value=");
        String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, resourceName);
        this.copyResourceFromJAR(resourcePath, WEBJAR_PATH, factoryContext);
        StringBuffer path = new StringBuffer("file://");
        factoryContext.adjustCSSPath(path);
        path.append(WEBJAR_PATH);
        path.append(resourcePath.replace(" ", "%20"));
        return new URI(path.toString()).toURL();
    }

    private File getJARFile(String resourceName) throws IOException {
        File file;
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        JarURLConnection connection = (JarURLConnection)resourceURL.openConnection();
        URL jarURL = connection.getJarFileURL();
        try {
            file = new File(jarURL.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(jarURL.getPath());
        }
        return file;
    }

    private void copyResourceFromJAR(String resourcePath, String prefix, ExportURLFactoryContext factoryContext) throws IOException {
        JarFile jar = new JarFile(this.getJARFile(resourcePath));
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            if (!entry.getName().startsWith(resourcePath) || entry.isDirectory()) continue;
            String targetPath = prefix + entry.getName();
            File targetLocation = new File(factoryContext.getExportDir(), targetPath);
            if (targetLocation.exists()) continue;
            targetLocation.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(targetLocation);
            InputStream is = jar.getInputStream(entry);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.close();
            is.close();
        }
        jar.close();
    }
}

