/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.velocity.VelocityManager;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractResourceReferenceHandler<EntityResourceAction> {
    public static final EntityResourceAction ACTION = new EntityResourceAction("webjars");
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String UTF8 = "UTF-8";
    @Inject
    private Container container;
    @Inject
    private VelocityManager velocityManager;
    private Tika tika = new Tika();

    public List<EntityResourceAction> getSupportedResourceReferences() {
        return Arrays.asList(ACTION);
    }

    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        if (!this.shouldBrowserUseCachedContent(reference)) {
            String resourceName = reference.getParameterValue("value");
            String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, resourceName);
            InputStream resourceStream = this.getClassLoader().getResourceAsStream(resourcePath);
            if (resourceStream != null) {
                if (this.shouldEvaluateResource(reference)) {
                    resourceStream = this.evaluate(resourceName, resourceStream);
                }
                if (!resourceStream.markSupported()) {
                    resourceStream = new BufferedInputStream(resourceStream);
                }
                try {
                    Response response = this.container.getResponse();
                    this.setResponseHeaders(response, reference);
                    response.setContentType(this.tika.detect(resourceStream, resourceName));
                    IOUtils.copy((InputStream)resourceStream, (OutputStream)this.container.getResponse().getOutputStream());
                }
                catch (Exception e) {
                    throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)resourceStream);
                }
            }
        }
        chain.handleNext(reference);
    }

    private void setResponseHeaders(Response response, ResourceReference reference) {
        if (response instanceof ServletResponse && !this.shouldEvaluateResource(reference)) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setDateHeader("Last-Modified", new Date().getTime() / 1000L * 1000L);
        }
    }

    private boolean shouldBrowserUseCachedContent(ResourceReference reference) {
        Response response;
        HttpServletRequest httpRequest;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && !this.shouldEvaluateResource(reference) && (httpRequest = ((ServletRequest)request).getHttpServletRequest()).getHeader("If-Modified-Since") != null && (response = this.container.getResponse()) instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setStatus(304);
            return true;
        }
        return false;
    }

    private boolean shouldEvaluateResource(ResourceReference reference) {
        return Boolean.valueOf(reference.getParameterValue("evaluate"));
    }

    private InputStream evaluate(String resourceName, InputStream resourceStream) throws ResourceReferenceHandlerException {
        try {
            StringWriter writer = new StringWriter();
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, resourceName, (Reader)new InputStreamReader(resourceStream, UTF8));
            return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException("Faild to evaluate the Velocity code from WebJar resource [" + resourceName + "]", (Throwable)e);
        }
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

