/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.script.service.ScriptService;
import org.xwiki.velocity.tools.EscapeTool;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsScriptService
implements ScriptService {
    private static final String VERSION = "version";
    private static final String DEFAULT_WEBJAR_GROUP_ID = "org.webjars";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    private EscapeTool escapeTool = new EscapeTool();

    public String url(String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return null;
        }
        String[] parts = resourceName.split("/", 3);
        if (parts.length < 3) {
            this.logger.warn("Invalid webjar resource name [{}]. Expected format is 'webjarId/version/path'", (Object)resourceName);
            return null;
        }
        return this.url("fakeGroupId:" + parts[0], parts[2], Collections.singletonMap(VERSION, parts[1]));
    }

    public String url(String webjarId, String path) {
        return this.url(webjarId, path, Collections.emptyMap());
    }

    public String url(String webjarId, String path, Map<String, ?> params) {
        Object version;
        if (StringUtils.isEmpty((CharSequence)webjarId)) {
            return null;
        }
        String groupId = DEFAULT_WEBJAR_GROUP_ID;
        String artifactId = webjarId;
        int groupSeparatorPosition = webjarId.indexOf(58);
        if (groupSeparatorPosition >= 0) {
            groupId = webjarId.substring(0, groupSeparatorPosition);
            artifactId = webjarId.substring(groupSeparatorPosition + 1);
        }
        LinkedHashMap<String, Object> urlParams = new LinkedHashMap<String, Object>();
        if (params != null) {
            urlParams.putAll(params);
        }
        if ((version = urlParams.remove(VERSION)) == null) {
            version = this.getVersion(String.format("%s:%s", groupId, artifactId));
        }
        String fullPath = String.format("%s/%s/%s", artifactId, version, path);
        urlParams.put("value", fullPath);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiURLFactory urlFactory = xcontext.getURLFactory();
        URL url = urlFactory.createURL("resources", "path", "webjars", this.escapeTool.url(urlParams), null, xcontext);
        return urlFactory.getURL(url, xcontext);
    }

    private String getVersion(String extensionId) {
        String namespace;
        CoreExtension extension = this.coreExtensionRepository.getCoreExtension(extensionId);
        if (extension == null && (extension = this.installedExtensionRepository.getInstalledExtension(extensionId, namespace = "wiki:" + this.wikiDescriptorManager.getCurrentWikiId())) == null) {
            return null;
        }
        return extension.getId().getVersion().getValue();
    }
}

