/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.velocity.VelocityManager;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractResourceReferenceHandler<EntityResourceAction> {
    public static final EntityResourceAction ACTION = new EntityResourceAction("webjars");
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String UTF8 = "UTF-8";
    private static final long CACHE_DURATION = 31536000000L;
    @Inject
    private Logger logger;
    @Inject
    private Container container;
    @Inject
    private VelocityManager velocityManager;
    private Tika tika = new Tika();

    public List<EntityResourceAction> getSupportedResourceReferences() {
        return Arrays.asList(ACTION);
    }

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        if (!this.shouldBrowserUseCachedContent(resourceReference)) {
            InputStream resourceStream = this.getResourceStream(resourceReference);
            if (resourceStream != null) {
                try {
                    this.serveResource(resourceReference, resourceStream);
                }
                catch (ResourceReferenceHandlerException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.sendError(500, e.getMessage(), new Object[0]);
                }
            } else {
                this.sendError(404, "Resource not found [%s].", this.getResourceName(resourceReference));
            }
        }
        chain.handleNext(resourceReference);
    }

    private boolean shouldBrowserUseCachedContent(ResourceReference resourceReference) {
        Response response;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && !this.shouldEvaluateResource(resourceReference) && ((ServletRequest)request).getHttpServletRequest().getHeader("If-Modified-Since") != null && (response = this.container.getResponse()) instanceof ServletResponse) {
            ((ServletResponse)response).getHttpServletResponse().setStatus(304);
            return true;
        }
        return false;
    }

    private InputStream getResourceStream(ResourceReference resourceReference) {
        String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, this.getResourceName(resourceReference));
        return this.getClassLoader().getResourceAsStream(resourcePath);
    }

    private String getResourceName(ResourceReference resourceReference) {
        return resourceReference.getParameterValue("value");
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void serveResource(ResourceReference resourceReference, InputStream rawResourceStream) throws ResourceReferenceHandlerException {
        InputStream resourceStream = rawResourceStream;
        String resourceName = this.getResourceName(resourceReference);
        if (this.shouldEvaluateResource(resourceReference)) {
            resourceStream = this.evaluate(resourceName, resourceStream);
        }
        if (!resourceStream.markSupported()) {
            resourceStream = new BufferedInputStream(resourceStream);
        }
        try {
            Response response = this.container.getResponse();
            this.setResponseHeaders(response, resourceReference);
            response.setContentType(this.tika.detect(resourceStream, resourceName));
            IOUtils.copy((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    private boolean shouldEvaluateResource(ResourceReference reference) {
        return Boolean.valueOf(reference.getParameterValue("evaluate"));
    }

    private InputStream evaluate(String resourceName, InputStream resourceStream) throws ResourceReferenceHandlerException {
        try {
            StringWriter writer = new StringWriter();
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, resourceName, (Reader)new InputStreamReader(resourceStream, UTF8));
            return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException("Faild to evaluate the Velocity code from WebJar resource [" + resourceName + "]", (Throwable)e);
        }
    }

    private void setResponseHeaders(Response response, ResourceReference reference) {
        if (response instanceof ServletResponse && !this.shouldEvaluateResource(reference)) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setHeader("Cache-Control", "public");
            httpResponse.setDateHeader("Expires", new Date().getTime() + 31536000000L);
            httpResponse.setDateHeader("Last-Modified", new Date().getTime());
        }
    }

    private void sendError(int statusCode, String message, Object ... parameters) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        if (response instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            try {
                httpResponse.sendError(statusCode, String.format(message, parameters));
            }
            catch (IOException e) {
                throw new ResourceReferenceHandlerException(String.format("Failed to return status code [%s].", statusCode), (Throwable)e);
            }
        }
    }
}

