/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreationStep;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="wikicreationjob")
public class WikiCreationJob
extends AbstractJob<WikiCreationRequest, DefaultJobStatus<WikiCreationRequest>> {
    public static final String JOB_ID_PREFIX = "wikicreation";
    public static final String JOB_TYPE = "wikicreationjob";

    protected void runInternal() throws Exception {
        try {
            List wikiCreationStepList = this.componentManager.getInstanceList(WikiCreationStep.class);
            Collections.sort(wikiCreationStepList, new Comparator<WikiCreationStep>(){

                @Override
                public int compare(WikiCreationStep o1, WikiCreationStep o2) {
                    return o1.getOrder() - o2.getOrder();
                }
            });
            this.progressManager.pushLevelProgress(wikiCreationStepList.size(), (Object)this);
            for (WikiCreationStep step : wikiCreationStepList) {
                this.progressManager.startStep((Object)this);
                step.execute((WikiCreationRequest)this.request);
            }
            this.progressManager.popLevelProgress((Object)this);
        }
        catch (ComponentLookupException | WikiCreationException e) {
            throw new WikiCreationException(String.format("Failed to execute creation steps on the wiki [%s].", ((WikiCreationRequest)this.request).getWikiId()), e);
        }
    }

    public String getType() {
        return JOB_TYPE;
    }
}

