/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal.steps;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreationStep;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="adduser")
public class AddUsersStep
implements WikiCreationStep {
    @Inject
    private WikiUserManager wikiUserManager;

    @Override
    public void execute(WikiCreationRequest request) throws WikiCreationException {
        try {
            String wikId = request.getWikiId();
            if (request.getMembers() != null) {
                this.wikiUserManager.addMembers(request.getMembers(), wikId);
            }
        }
        catch (WikiUserManagerException e) {
            throw new WikiCreationException(String.format("Failed to add members to the wiki [%s].", request.getWikiId()), e);
        }
    }

    @Override
    public int getOrder() {
        return 4000;
    }
}

