/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.properties;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.internal.descriptor.properties.WikiPropertyGroupManager;
import org.xwiki.wiki.properties.WikiPropertyGroup;
import org.xwiki.wiki.properties.WikiPropertyGroupException;
import org.xwiki.wiki.properties.WikiPropertyGroupProvider;

@Component
@Singleton
public class DefaultWikiPropertyGroupManager
implements WikiPropertyGroupManager {
    @Inject
    private Map<String, WikiPropertyGroupProvider> propertyGroupProviders;
    @Inject
    private Logger logger;

    @Override
    public void loadForDescriptor(WikiDescriptor descriptor) throws WikiPropertyGroupException {
        String wikiId = descriptor.getId();
        for (String propertyGroupName : this.propertyGroupProviders.keySet()) {
            WikiPropertyGroupProvider provider = this.propertyGroupProviders.get(propertyGroupName);
            try {
                descriptor.addPropertyGroup(provider.get(wikiId));
            }
            catch (WikiPropertyGroupException e) {
                this.logger.warn(String.format("Unable to load property groups [%s].", propertyGroupName), (Throwable)e);
            }
        }
    }

    @Override
    public void saveForDescriptor(WikiDescriptor descriptor) throws WikiPropertyGroupException {
        String wikiId = descriptor.getId();
        for (String propertyGroupName : this.propertyGroupProviders.keySet()) {
            WikiPropertyGroup group = descriptor.getPropertyGroup(propertyGroupName);
            if (group == null) continue;
            WikiPropertyGroupProvider provider = this.propertyGroupProviders.get(propertyGroupName);
            provider.save(group, wikiId);
        }
    }
}

