/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.document;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.wiki.internal.descriptor.document.XWikiServerClassDocumentInitializer;

@Component
@Named(value="XWiki.XWikiServerXwiki")
@Singleton
public class XWikiServerXwikiDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "XWikiServerXwiki";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private Container container;

    public XWikiServerXwikiDocumentInitializer() {
        super((EntityReference)new LocalDocumentReference("XWiki", DOCUMENT_NAME));
    }

    public boolean isMainWikiOnly() {
        return true;
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = super.updateDocument(document);
        if (document.getXObject((EntityReference)XWikiServerClassDocumentInitializer.SERVER_CLASS) == null) {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            try {
                BaseObject xobject = document.newXObject((EntityReference)XWikiServerClassDocumentInitializer.SERVER_CLASS, xcontext);
                xobject.setLargeStringValue("description", "Main wiki");
                xobject.setStringValue("homepage", "Main.WebHome");
                xobject.setStringValue("language", "en");
                xobject.setStringValue("state", "active");
                xobject.setStringValue("visibility", "public");
                xobject.setLargeStringValue("owner", "XWiki.superadmin");
                xobject.setStringValue("wikiprettyname", "Home");
                Request request = this.container.getRequest();
                if (request instanceof ServletRequest) {
                    ServletRequest servletRequest = (ServletRequest)request;
                    URL sourceURL = HttpServletUtils.getSourceBaseURL((HttpServletRequest)servletRequest.getHttpServletRequest());
                    xobject.setStringValue("server", sourceURL.getHost());
                    if (sourceURL.getProtocol().equals("https")) {
                        xobject.setIntValue("secure", 1);
                    }
                    if (sourceURL.getPort() != -1) {
                        xobject.setIntValue("port", sourceURL.getPort());
                    }
                } else {
                    xobject.setStringValue("server", "localhost");
                    xobject.setIntValue("secure", 0);
                }
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error("Faied to initialize main wiki descriptor", (Throwable)e);
            }
        }
        return needsUpdate;
    }
}

