/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilder;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilderException;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.internal.manager.WikiDescriptorCache;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiDescriptorManager
implements WikiDescriptorManager {
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorCache cache;
    @Inject
    private Provider<WikiDescriptorDocumentHelper> descriptorDocumentHelperProvider;
    @Inject
    private Provider<WikiDescriptorBuilder> wikiDescriptorBuilderProvider;

    public Collection<WikiDescriptor> getAll() throws WikiManagerException {
        Collection<String> wikiIds = this.getAllIds();
        ArrayList<WikiDescriptor> result = new ArrayList<WikiDescriptor>(wikiIds.size());
        for (String wikiId : wikiIds) {
            WikiDescriptor descriptor = this.getById(wikiId);
            if (descriptor == null) continue;
            result.add(descriptor);
        }
        return result;
    }

    public Collection<String> getAllIds() throws WikiManagerException {
        Collection<String> wikiIds = this.cache.getWikiIds();
        if (wikiIds == null) {
            List<String> documentNames;
            try {
                documentNames = ((WikiDescriptorDocumentHelper)this.descriptorDocumentHelperProvider.get()).getAllXWikiServerClassDocumentNames();
            }
            catch (Exception e) {
                throw new WikiManagerException("Failed to get wiki ids", (Throwable)e);
            }
            wikiIds = new HashSet<String>(documentNames.size());
            boolean foundMainWiki = false;
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            for (String documentName : documentNames) {
                String wikId = ((WikiDescriptorDocumentHelper)this.descriptorDocumentHelperProvider.get()).getWikiIdFromDocumentFullname(documentName);
                wikiIds.add(wikId);
                foundMainWiki |= xcontext.isMainWiki(wikId);
            }
            if (!foundMainWiki) {
                wikiIds.add(this.getMainWikiId());
            }
            this.cache.setWikiIds(Collections.unmodifiableCollection(wikiIds));
        }
        return wikiIds;
    }

    public WikiDescriptor getByAlias(String wikiAlias) throws WikiManagerException {
        DefaultWikiDescriptor descriptor = this.cache.getFromAlias(wikiAlias);
        if (descriptor == null) {
            XWikiDocument document = ((WikiDescriptorDocumentHelper)this.descriptorDocumentHelperProvider.get()).findXWikiServerClassDocument(wikiAlias);
            if (document != null) {
                descriptor = this.buildDescriptorFromDocument(document);
            }
            if (descriptor == null) {
                this.cache.addFromAlias(wikiAlias, DefaultWikiDescriptor.VOID);
            }
        }
        return descriptor != DefaultWikiDescriptor.VOID && descriptor != null ? descriptor.clone() : null;
    }

    public WikiDescriptor getById(String wikiId) throws WikiManagerException {
        DefaultWikiDescriptor descriptor = this.cache.getFromId(wikiId);
        if (descriptor == null) {
            XWikiDocument document = ((WikiDescriptorDocumentHelper)this.descriptorDocumentHelperProvider.get()).getDocumentFromWikiId(wikiId);
            if (!document.isNew()) {
                descriptor = this.buildDescriptorFromDocument(document);
            } else if (this.getMainWikiId().equals(wikiId)) {
                descriptor = new WikiDescriptor(wikiId, "localhost");
            }
            if (descriptor == null) {
                this.cache.addFromId(wikiId, DefaultWikiDescriptor.VOID);
            }
        }
        return descriptor != DefaultWikiDescriptor.VOID && descriptor != null ? descriptor.clone() : null;
    }

    public boolean exists(String wikiId) throws WikiManagerException {
        return this.getAllIds().contains(wikiId);
    }

    public void saveDescriptor(WikiDescriptor descriptor) throws WikiManagerException {
        try {
            ((WikiDescriptorBuilder)this.wikiDescriptorBuilderProvider.get()).save(descriptor);
        }
        catch (WikiDescriptorBuilderException e) {
            throw new WikiManagerException(String.format("Unable to save wiki descriptor for [%s].", descriptor.getId()), (Throwable)e);
        }
    }

    public WikiDescriptor getMainWikiDescriptor() throws WikiManagerException {
        return this.getById(this.getMainWikiId());
    }

    public String getMainWikiId() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext != null ? xcontext.getMainXWiki() : "xwiki";
    }

    public boolean isMainWiki(String wikiId) {
        if (StringUtils.isEmpty((CharSequence)wikiId)) {
            return true;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext != null ? xcontext.isMainWiki(wikiId) : true;
    }

    public String getCurrentWikiId() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext != null ? xcontext.getWikiId() : null;
    }

    public WikiReference getCurrentWikiReference() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext != null ? xcontext.getWikiReference() : null;
    }

    public WikiDescriptor getCurrentWikiDescriptor() throws WikiManagerException {
        return this.getById(this.getCurrentWikiId());
    }

    private DefaultWikiDescriptor buildDescriptorFromDocument(XWikiDocument document) {
        DefaultWikiDescriptor descriptor = null;
        List serverClassObjects = document.getXObjects((EntityReference)DefaultWikiDescriptor.SERVER_CLASS);
        if (serverClassObjects != null && !serverClassObjects.isEmpty() && (descriptor = ((WikiDescriptorBuilder)this.wikiDescriptorBuilderProvider.get()).buildDescriptorObject(serverClassObjects, document)) != null) {
            this.cache.add(descriptor);
        }
        return descriptor;
    }
}

