/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilder;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilderException;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.internal.manager.WikiDescriptorCache;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiDescriptorManager
implements WikiDescriptorManager {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorCache cache;
    @Inject
    private WikiDescriptorDocumentHelper descriptorDocumentHelper;
    @Inject
    private WikiDescriptorBuilder wikiDescriptorBuilder;

    public Collection<WikiDescriptor> getAll() throws WikiManagerException {
        ArrayList<WikiDescriptor> result = new ArrayList<WikiDescriptor>();
        try {
            List<String> documentNames = this.descriptorDocumentHelper.getAllXWikiServerClassDocumentNames();
            for (String documentName : documentNames) {
                String wikiId = this.descriptorDocumentHelper.getWikiIdFromDocumentFullname(documentName);
                DefaultWikiDescriptor descriptor = this.cache.getFromId(wikiId);
                if (descriptor == null) {
                    XWikiDocument document = this.descriptorDocumentHelper.getDocumentFromWikiId(wikiId);
                    descriptor = this.buildDescriptorFromDocument(document);
                }
                if (descriptor == null) continue;
                result.add(descriptor);
            }
        }
        catch (Exception e) {
            throw new WikiManagerException("Failed to locate XWiki.XWikiServerClass documents", (Throwable)e);
        }
        return result;
    }

    public WikiDescriptor getByAlias(String wikiAlias) throws WikiManagerException {
        XWikiDocument document;
        DefaultWikiDescriptor descriptor = this.cache.getFromAlias(wikiAlias);
        if (descriptor == null && (document = this.descriptorDocumentHelper.findXWikiServerClassDocument(wikiAlias)) != null) {
            descriptor = this.buildDescriptorFromDocument(document);
        }
        return descriptor;
    }

    public WikiDescriptor getById(String wikiId) throws WikiManagerException {
        XWikiDocument document;
        DefaultWikiDescriptor descriptor = this.cache.getFromId(wikiId);
        if (descriptor == null && !(document = this.descriptorDocumentHelper.getDocumentFromWikiId(wikiId)).isNew()) {
            descriptor = this.buildDescriptorFromDocument(document);
        }
        return descriptor;
    }

    public boolean exists(String wikiId) throws WikiManagerException {
        return this.getById(wikiId) != null;
    }

    public void saveDescriptor(WikiDescriptor descriptor) throws WikiManagerException {
        try {
            this.wikiDescriptorBuilder.save(descriptor);
        }
        catch (WikiDescriptorBuilderException e) {
            throw new WikiManagerException(String.format("Unable to save wiki descriptor for [%s].", descriptor.getId()), (Throwable)e);
        }
    }

    public WikiDescriptor getMainWikiDescriptor() throws WikiManagerException {
        return this.getById(this.getMainWikiId());
    }

    public String getMainWikiId() {
        return ((XWikiContext)this.xcontextProvider.get()).getMainXWiki();
    }

    public String getCurrentWikiId() {
        return ((XWikiContext)this.xcontextProvider.get()).getDatabase();
    }

    private DefaultWikiDescriptor buildDescriptorFromDocument(XWikiDocument document) {
        DefaultWikiDescriptor descriptor = null;
        List serverClassObjects = document.getXObjects(DefaultWikiDescriptor.SERVER_CLASS);
        if (serverClassObjects != null && (descriptor = this.wikiDescriptorBuilder.buildDescriptorObject(serverClassObjects, document)) != null) {
            this.cache.add(descriptor);
        }
        return descriptor;
    }
}

