/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.builder;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilder;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilderException;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.internal.descriptor.properties.WikiPropertyGroupManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.properties.WikiPropertyGroupException;

@Component
@Singleton
public class DefaultWikiDescriptorBuilder
implements WikiDescriptorBuilder {
    static final String VALID_PAGE_PREFIX = "XWikiServer";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    @Inject
    private Provider<WikiPropertyGroupManager> wikiPropertyGroupManagerProvider;
    @Inject
    private WikiDescriptorDocumentHelper wikiDescriptorDocumentHelper;
    @Inject
    private Logger logger;

    @Override
    public DefaultWikiDescriptor buildDescriptorObject(List<BaseObject> serverClassObjects, XWikiDocument document) {
        DefaultWikiDescriptor descriptor = this.extractWikiDescriptor(serverClassObjects.get(0), document);
        if (descriptor != null) {
            for (int i = 1; i < serverClassObjects.size(); ++i) {
                BaseObject serverClassObject = serverClassObjects.get(i);
                if (serverClassObject == null) continue;
                String descriptorAlias = this.extractWikiAlias(serverClassObject);
                descriptor.addAlias(descriptorAlias);
            }
            BaseObject object = serverClassObjects.get(0);
            descriptor.setMainPageReference(this.referenceResolver.resolve((Object)object.getStringValue("homepage"), new Object[0]));
            descriptor.setPrettyName(object.getStringValue("wikiprettyname"));
            descriptor.setOwnerId(object.getStringValue("owner"));
            descriptor.setDescription(object.getStringValue("description"));
            try {
                WikiPropertyGroupManager wikiPropertyGroupManager = (WikiPropertyGroupManager)this.wikiPropertyGroupManagerProvider.get();
                wikiPropertyGroupManager.loadForDescriptor(descriptor);
            }
            catch (WikiPropertyGroupException e) {
                this.logger.error("Failed to load wiki property groups for wiki [{}].", (Object)descriptor.getId(), (Object)e);
            }
        }
        return descriptor;
    }

    private DefaultWikiDescriptor extractWikiDescriptor(BaseObject serverClassObject, XWikiDocument document) {
        String wikiId;
        DefaultWikiDescriptor descriptor = null;
        String serverProperty = this.extractWikiAlias(serverClassObject);
        if (!StringUtils.isBlank((CharSequence)serverProperty) && (wikiId = this.extractWikiId(document)) != null) {
            descriptor = new DefaultWikiDescriptor(wikiId, serverProperty);
        }
        return descriptor;
    }

    private String extractWikiAlias(BaseObject serverClassObject) {
        return serverClassObject.getStringValue("server");
    }

    private String extractWikiId(XWikiDocument document) {
        String wikiId = null;
        String pageName = document.getDocumentReference().getName();
        if (pageName.startsWith(VALID_PAGE_PREFIX)) {
            wikiId = StringUtils.removeStart((String)pageName, (String)VALID_PAGE_PREFIX).toLowerCase();
        }
        return wikiId;
    }

    @Override
    public XWikiDocument save(WikiDescriptor descriptor) throws WikiDescriptorBuilderException {
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        XWikiDocument descriptorDoc = null;
        try {
            descriptorDoc = this.wikiDescriptorDocumentHelper.getDocumentFromWikiId(descriptor.getId());
            BaseObject obj = descriptorDoc.getXObject(DefaultWikiDescriptor.SERVER_CLASS, true, context);
            obj.set("server", (Object)descriptor.getDefaultAlias(), context);
            obj.set("homepage", this.referenceSerializer.serialize((EntityReference)descriptor.getMainPageReference(), new Object[0]), context);
            obj.set("owner", (Object)descriptor.getOwnerId(), context);
            obj.set("wikiprettyname", (Object)descriptor.getPrettyName(), context);
            obj.set("description", (Object)descriptor.getDescription(), context);
            List aliases = descriptor.getAliases();
            DocumentReference serverClass = new DocumentReference(wikiDescriptorManager.getMainWikiId(), DefaultWikiDescriptor.SERVER_CLASS.getParent().getName(), DefaultWikiDescriptor.SERVER_CLASS.getName());
            for (int i = 1; i < aliases.size(); ++i) {
                String alias = (String)aliases.get(i);
                BaseObject objAlias = descriptorDoc.getXObject(serverClass, "server", alias, true);
                objAlias.set("server", (Object)alias, context);
            }
            descriptorDoc.setHidden(Boolean.valueOf(true));
            if (descriptorDoc.getCreatorReference() == null) {
                descriptorDoc.setCreatorReference(context.getUserReference());
            }
            if (descriptorDoc.getAuthorReference() == null) {
                descriptorDoc.setAuthorReference(context.getUserReference());
            }
            DocumentReference parentReference = new DocumentReference(wikiDescriptorManager.getMainWikiId(), "WikiManager", "WebHome");
            descriptorDoc.setParentReference(parentReference);
            xwiki.saveDocument(descriptorDoc, context);
            WikiPropertyGroupManager wikiPropertyGroupManager = (WikiPropertyGroupManager)this.wikiPropertyGroupManagerProvider.get();
            wikiPropertyGroupManager.saveForDescriptor(descriptor);
        }
        catch (WikiManagerException e) {
            throw new WikiDescriptorBuilderException("Unable to load the descriptor document", e);
        }
        catch (XWikiException e) {
            throw new WikiDescriptorBuilderException("Unable to save the descriptor document", e);
        }
        catch (WikiPropertyGroupException e) {
            throw new WikiDescriptorBuilderException("Unable to save the property groups", e);
        }
        return descriptorDoc;
    }
}

