/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.document;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiDescriptorDocumentHelper
implements WikiDescriptorDocumentHelper {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private ComponentManager componentManager;

    @Override
    public DocumentReference getDocumentReferenceFromId(String wikiId) {
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        return new DocumentReference(wikiDescriptorManager.getMainWikiId(), "XWiki", String.format("XWikiServer%s", StringUtils.capitalize((String)wikiId)));
    }

    @Override
    public String getWikiIdFromDocumentReference(DocumentReference descriptorDocumentReference) {
        String docName = descriptorDocumentReference.getName();
        return StringUtils.removeStart((String)docName, (String)"XWikiServer").toLowerCase();
    }

    @Override
    public String getWikiIdFromDocumentFullname(String descriptorDocumentFullname) {
        return StringUtils.removeStart((String)descriptorDocumentFullname, (String)"XWiki.XWikiServer").toLowerCase();
    }

    @Override
    public XWikiDocument getDocumentFromWikiId(String wikiId) throws WikiManagerException {
        return this.getDocument(this.getDocumentReferenceFromId(wikiId));
    }

    @Override
    public DocumentReference findXWikiServerClassDocumentReference(String wikiAlias) throws WikiManagerException {
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        DocumentReference result = null;
        try {
            Query query = this.queryManager.createQuery("where doc.object(XWiki.XWikiServerClass).server = :wikiAlias and doc.name like 'XWikiServer%'", "xwql");
            query.bindValue("wikiAlias", (Object)wikiAlias);
            query.setWiki(wikiDescriptorManager.getMainWikiId());
            List documentNames = query.execute();
            if (documentNames != null && !documentNames.isEmpty()) {
                result = this.documentReferenceResolver.resolve(documentNames.get(0), new Object[0]);
            }
        }
        catch (QueryException e) {
            throw new WikiManagerException(String.format("Failed to locate XWiki.XWikiServerClass document for wiki alias [%s]", wikiAlias), (Throwable)e);
        }
        return result;
    }

    @Override
    public XWikiDocument findXWikiServerClassDocument(String wikiAlias) throws WikiManagerException {
        XWikiDocument document = null;
        DocumentReference documentReference = this.findXWikiServerClassDocumentReference(wikiAlias);
        if (documentReference != null) {
            document = this.getDocument(documentReference);
        }
        return document;
    }

    @Override
    public List<XWikiDocument> getAllXWikiServerClassDocument() throws WikiManagerException {
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        ArrayList<XWikiDocument> result = new ArrayList<XWikiDocument>();
        List<String> documentNames = this.getAllXWikiServerClassDocumentNames();
        if (documentNames != null) {
            for (String documentName : documentNames) {
                DocumentReference docRef = this.documentReferenceResolver.resolve((Object)documentName, new Object[0]);
                docRef = new DocumentReference(wikiDescriptorManager.getMainWikiId(), docRef.getLastSpaceReference().getName(), docRef.getName());
                result.add(this.getDocument(docRef));
            }
        }
        return result;
    }

    @Override
    public List<String> getAllXWikiServerClassDocumentNames() throws WikiManagerException {
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        try {
            Query query = this.queryManager.createQuery("from doc.object(XWiki.XWikiServerClass) as descriptor where doc.name like 'XWikiServer%' and doc.fullName <> 'XWiki.XWikiServerClassTemplate'", "xwql");
            query.setWiki(wikiDescriptorManager.getMainWikiId());
            query.addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "unique"));
            return query.execute();
        }
        catch (Exception e) {
            throw new WikiManagerException("Failed to locate XWiki.XWikiServerClass documents", (Throwable)e);
        }
    }

    private XWikiDocument getDocument(DocumentReference reference) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            return xwiki.getDocument(reference, context);
        }
        catch (XWikiException e) {
            throw new WikiManagerException(String.format("Failed to get document [%s] containing a XWiki.XWikiServerClass object", reference), (Throwable)e);
        }
    }
}

