/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.wiki.internal.manager.WikiCopier;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
public class DefaultWikiCopier
implements WikiCopier {
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private ObservationManager observationManager;

    @Override
    public void copyDocuments(String fromWikiId, String toWikiId, boolean withHistory) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            Query query = this.queryManager.createQuery("select distinct doc.fullName from Document as doc", "xwql");
            query.setWiki(fromWikiId);
            List documentFullnames = query.execute();
            this.observationManager.notify((Event)new PushLevelProgressEvent(documentFullnames.size()), (Object)this);
            WikiReference fromWikiReference = new WikiReference(fromWikiId);
            for (String documentFullName : documentFullnames) {
                DocumentReference origDocReference = this.documentReferenceResolver.resolve((Object)documentFullName, new Object[]{fromWikiReference});
                DocumentReference newDocReference = new DocumentReference(toWikiId, origDocReference.getLastSpaceReference().getName(), origDocReference.getName());
                xwiki.copyDocument(origDocReference, newDocReference, null, !withHistory, true, context);
                this.observationManager.notify((Event)new StepProgressEvent(), (Object)this);
            }
            this.handleAppDescriptors(fromWikiId, toWikiId);
            this.observationManager.notify((Event)new PopLevelProgressEvent(), (Object)this);
        }
        catch (QueryException e) {
            throw new WikiManagerException("Unable to get the source wiki documents.", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new WikiManagerException("Failed to copy document.", (Throwable)e);
        }
    }

    @Override
    public void copyDeletedDocuments(String fromWikiId, String toWikiId) throws WikiManagerException {
        throw new WikiManagerException("This method is not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String>[] getDocsNames(String wiki, XWikiContext context) throws XWikiException {
        Collection[] docsNames = new Collection[2];
        ApplicationManagerPluginApi appmanager = (ApplicationManagerPluginApi)context.getWiki().getPluginApi("applicationmanager", context);
        if (appmanager == null) {
            return null;
        }
        String database = context.getDatabase();
        try {
            context.setDatabase(wiki);
            XWikiApplication rootApp = appmanager.getRootApplication();
            if (rootApp != null) {
                docsNames[0] = rootApp.getDocsNameToInclude(true);
                docsNames[1] = rootApp.getDocsNameToLink(true);
            } else {
                List applications = appmanager.getApplicationDocumentList();
                docsNames[0] = XWikiApplication.getDocsNameToInclude((Collection)applications);
                docsNames[1] = XWikiApplication.getDocsNameToLink((Collection)applications);
            }
        }
        finally {
            context.setDatabase(database);
        }
        return docsNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAppDescriptors(String sourceWiki, String targetWiki) throws XWikiException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        String database = context.getDatabase();
        try {
            context.setDatabase(targetWiki);
            Collection<String>[] docsNames = this.getDocsNames(sourceWiki, context);
            if (docsNames != null) {
                XWikiDocument targetDoc;
                String docFullName;
                String item;
                Object[] includeFormatParams = new Object[]{sourceWiki, ":", null};
                Iterator<String> i$ = docsNames[0].iterator();
                while (i$.hasNext()) {
                    docFullName = item = i$.next();
                    targetDoc = xwiki.getDocument(docFullName, context);
                    includeFormatParams[2] = docFullName;
                    targetDoc.setContent(MessageFormat.format("#includeInContext(\"{0}{1}{2}\")", includeFormatParams));
                    targetDoc.setSyntax(Syntax.XWIKI_1_0);
                    xwiki.saveDocument(targetDoc, context);
                }
                i$ = docsNames[1].iterator();
                while (i$.hasNext()) {
                    docFullName = item = i$.next();
                    targetDoc = xwiki.getDocument(docFullName, context);
                    includeFormatParams[2] = docFullName;
                    targetDoc.setContent(MessageFormat.format("#includeTopic(\"{0}{1}{2}\")", includeFormatParams));
                    targetDoc.setSyntax(Syntax.XWIKI_1_0);
                    xwiki.saveDocument(targetDoc, context);
                }
            }
        }
        finally {
            context.setDatabase(database);
        }
    }
}

