/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.internal.manager.WikiCopier;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
public class DefaultWikiCopier
implements WikiCopier {
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private ObservationManager observationManager;

    @Override
    public void copyDocuments(String fromWikiId, String toWikiId, boolean withHistory) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            Query query = this.queryManager.createQuery("select distinct doc.fullName from Document as doc", "xwql");
            query.setWiki(fromWikiId);
            List documentFullnames = query.execute();
            this.observationManager.notify((Event)new PushLevelProgressEvent(documentFullnames.size()), (Object)this);
            WikiReference fromWikiReference = new WikiReference(fromWikiId);
            for (String documentFullName : documentFullnames) {
                DocumentReference origDocReference = this.documentReferenceResolver.resolve((Object)documentFullName, new Object[]{fromWikiReference});
                DocumentReference newDocReference = new DocumentReference(toWikiId, origDocReference.getLastSpaceReference().getName(), origDocReference.getName());
                xwiki.copyDocument(origDocReference, newDocReference, null, !withHistory, true, context);
                this.observationManager.notify((Event)new StepProgressEvent(), (Object)this);
            }
            this.observationManager.notify((Event)new PopLevelProgressEvent(), (Object)this);
        }
        catch (QueryException e) {
            throw new WikiManagerException("Unable to get the source wiki documents.", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new WikiManagerException("Failed to copy document.", (Throwable)e);
        }
    }

    @Override
    public void copyDeletedDocuments(String fromWikiId, String toWikiId) throws WikiManagerException {
        throw new WikiManagerException("This method is not implemented yet");
    }
}

