/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.manager.WikiDescriptorCache;

@Component
@Singleton
public class DefaultWikiDescriptorCache
implements WikiDescriptorCache,
Initializable {
    @Inject
    private CacheManager cacheManager;
    private Cache<DefaultWikiDescriptor> wikiAliasCache;
    private Cache<DefaultWikiDescriptor> wikiIdCache;
    private Collection<String> wikiIds;

    public void initialize() throws InitializationException {
        this.wikiAliasCache = this.createCache("wiki.descriptor.cache.wikiAlias");
        this.wikiIdCache = this.createCache("wiki.descriptor.cache.wikiId");
    }

    private Cache<DefaultWikiDescriptor> createCache(String cacheId) throws InitializationException {
        CacheConfiguration configuration = new CacheConfiguration(cacheId);
        try {
            return this.cacheManager.createNewCache(configuration);
        }
        catch (CacheException e) {
            throw new InitializationException(String.format("Failed to initialize wiki descriptor caches [%s]", configuration.getConfigurationId()), (Throwable)e);
        }
    }

    @Override
    public void add(DefaultWikiDescriptor descriptor) {
        this.wikiIdCache.set(descriptor.getId(), (Object)descriptor);
        for (String alias : descriptor.getAliases()) {
            this.wikiAliasCache.set(alias, (Object)descriptor);
        }
    }

    @Override
    public void remove(DefaultWikiDescriptor descriptor) {
        this.wikiIdCache.remove(descriptor.getId());
        for (String alias : descriptor.getAliases()) {
            this.wikiAliasCache.remove(alias);
        }
    }

    @Override
    public DefaultWikiDescriptor getFromId(String wikiId) {
        return (DefaultWikiDescriptor)((Object)this.wikiIdCache.get(wikiId));
    }

    @Override
    public DefaultWikiDescriptor getFromAlias(String wikiAlias) {
        return (DefaultWikiDescriptor)((Object)this.wikiAliasCache.get(wikiAlias));
    }

    @Override
    public void setWikiIds(Collection<String> wikiIds) {
        this.wikiIds = wikiIds;
    }

    @Override
    public Collection<String> getWikiIds() {
        return this.wikiIds;
    }
}

