/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.document;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.XWikiServerClass")
@Singleton
public class XWikiServerClassDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "XWikiServerClass";
    public static final EntityReference SERVER_CLASS = new EntityReference("XWikiServerClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final String DEFAULT_FIELDS_SEPARATOR = "|";
    public static final String FIELD_WIKIPRETTYNAME = "wikiprettyname";
    public static final String FIELDPN_WIKIPRETTYNAME = "Wiki pretty name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELDPN_OWNER = "Owner";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELDPN_DESCRIPTION = "Description";
    public static final String FIELD_SERVER = "server";
    public static final String FIELDPN_SERVER = "Server";
    public static final String FIELD_VISIBILITY = "visibility";
    public static final String FIELDL_VISIBILITY_PUBLIC = "public";
    public static final String FIELDL_VISIBILITY_PRIVATE = "private";
    public static final String FIELDL_VISIBILITY = "public|private|";
    public static final String FIELDPN_VISIBILITY = "Visibility";
    public static final String FIELD_STATE = "state";
    public static final String FIELDL_STATE_ACTIVE = "active";
    public static final String FIELDL_STATE_INACTIVE = "inactive";
    public static final String FIELDL_STATE_LOCKED = "locked";
    public static final String FIELDL_STATE = "active|inactive|locked";
    public static final String FIELDPN_STATE = "State";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELDL_LANGUAGE = "en|fr";
    public static final String FIELDPN_LANGUAGE = "Language";
    public static final String FIELD_SECURE = "secure";
    public static final String FIELDPN_SECURE = "Secure";
    public static final String FIELDDT_SECURE = "checkbox";
    public static final Boolean DEFAULT_SECURE = Boolean.FALSE;
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELDPN_HOMEPAGE = "Home page";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private DocumentReference reference;

    public XWikiServerClassDocumentInitializer() {
        super("XWiki", DOCUMENT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityReference getDocumentReference() {
        if (this.reference == null) {
            XWikiServerClassDocumentInitializer xWikiServerClassDocumentInitializer = this;
            synchronized (xWikiServerClassDocumentInitializer) {
                if (this.reference == null) {
                    String mainWikiName = ((XWikiContext)this.xcontextProvider.get()).getMainXWiki();
                    this.reference = new DocumentReference(mainWikiName, "XWiki", DOCUMENT_NAME);
                }
            }
        }
        return this.reference;
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        BaseClass baseClass = document.getXClass();
        needsUpdate |= baseClass.addTextField(FIELD_WIKIPRETTYNAME, FIELDPN_WIKIPRETTYNAME, 30);
        needsUpdate |= baseClass.addUsersField(FIELD_OWNER, FIELDPN_OWNER, false);
        needsUpdate |= baseClass.addTextAreaField(FIELD_DESCRIPTION, FIELDPN_DESCRIPTION, 40, 5);
        needsUpdate |= baseClass.addTextField(FIELD_SERVER, FIELDPN_SERVER, 30);
        needsUpdate |= baseClass.addStaticListField(FIELD_VISIBILITY, FIELDPN_VISIBILITY, FIELDL_VISIBILITY);
        needsUpdate |= baseClass.addStaticListField(FIELD_STATE, FIELDPN_STATE, FIELDL_STATE);
        needsUpdate |= baseClass.addStaticListField(FIELD_LANGUAGE, FIELDPN_LANGUAGE, FIELDL_LANGUAGE);
        needsUpdate |= baseClass.addBooleanField(FIELD_SECURE, FIELDPN_SECURE, FIELDDT_SECURE);
        needsUpdate |= this.updateBooleanClassDefaultValue(baseClass, FIELD_SECURE, DEFAULT_SECURE);
        needsUpdate |= baseClass.addTextField(FIELD_HOMEPAGE, FIELDPN_HOMEPAGE, 30);
        needsUpdate |= this.setClassDocumentFields(document, "XWiki Server Class");
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", "XWikiServerClassSheet");
            needsUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needsUpdate;
    }
}

