/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.migrator;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.document.XWikiServerClassDocumentInitializer;

@Component
@Named(value="R54300WikiDescriptorMigration")
@Singleton
public class WikiDescriptorMigrator
extends AbstractHibernateDataMigration {
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "http://jira.xwiki.org/browse/XWIKI-10091";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(54300);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return this.wikiDescriptorManager.getCurrentWikiId().equals(this.wikiDescriptorManager.getMainWikiId());
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        String hql = "SELECT DISTINCT doc.fullName FROM XWikiDocument doc, BaseObject obj WHERE doc.fullName = obj.name AND obj.className = :className AND doc.fullName <> :template AND doc.fullName NOT IN (SELECT DISTINCT doc2.fullName FROM XWikiDocument doc2, BaseObject obj2, StringProperty propPrettyName WHERE doc2.fullName = obj2.name AND obj2.className = :className AND propPrettyName.id = obj2.id AND propPrettyName.name = :propertyName)";
        try {
            Query query = this.queryManager.createQuery(hql, "hql");
            query.bindValue("className", (Object)String.format("%s.%s", "XWiki", "XWikiServerClass"));
            query.bindValue("propertyName", (Object)"wikiprettyname");
            query.bindValue("template", (Object)"XWiki.XWikiServerClassTemplate");
            List results = query.execute();
            for (String result : results) {
                this.fixDocument(result);
            }
        }
        catch (QueryException e) {
            this.logger.error("Failed to perform a query on the main wiki.", (Throwable)e);
        }
    }

    private void fixDocument(String documentName) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        DocumentReference documentReference = this.documentReferenceResolver.resolve((Object)documentName, new Object[0]);
        try {
            XWikiDocument document = xwiki.getDocument(documentReference, context);
            List objects = document.getXObjects((EntityReference)XWikiServerClassDocumentInitializer.SERVER_CLASS);
            for (BaseObject obj : objects) {
                String value;
                if (obj == null || !StringUtils.isBlank((String)(value = obj.getStringValue("wikiprettyname")))) continue;
                obj.setStringValue("wikiprettyname", StringUtils.capitalize((String)StringUtils.removeStart((String)documentReference.getName(), (String)"XWikiServer")));
            }
            xwiki.saveDocument(document, "[UPGRADE] Set a default pretty name.", context);
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get or save the wiki descriptor document [{}]. You will not see the corresponding wiki in the Wiki Index unless you give it a Pretty Name manually. {}", (Object)documentName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

