/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchPluginApi;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPlugin;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPluginApi;
import com.xpn.xwiki.plugin.wikimanager.doc.Wiki;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="wikimanager")
public class WikiManagerScriptService
implements ScriptService {
    private static final String PLUGINAPI_KEY = "wikimanagerapi";
    private static final String PLUGIN_ID = "wikimanager";
    @Inject
    private Execution execution;
    private WikiManagerPlugin plugin;

    private WikiManagerPlugin getPlugin(XWikiContext xcontext) {
        this.plugin = (WikiManagerPlugin)xcontext.getWiki().getPlugin(PLUGIN_ID, xcontext);
        if (this.plugin == null) {
            this.plugin = new WikiManagerPlugin(PLUGIN_ID, WikiManagerPlugin.class.getName(), xcontext);
            this.plugin.init(xcontext);
        }
        return this.plugin;
    }

    private WikiManagerPluginApi getAPI() {
        ExecutionContext econtext = this.execution.getContext();
        WikiManagerPluginApi api = (WikiManagerPluginApi)((Object)econtext.getProperty(PLUGINAPI_KEY));
        if (api == null) {
            XWikiContext xcontext = (XWikiContext)econtext.getProperty("xwikicontext");
            api = (WikiManagerPluginApi)this.getPlugin(xcontext).getPluginApi((XWikiPluginInterface)this.plugin, xcontext);
            econtext.setProperty(PLUGINAPI_KEY, (Object)api);
        }
        return api;
    }

    public XWikiExceptionApi getDefaultException() {
        return this.getAPI().getDefaultException();
    }

    public XWikiMessageTool getMessageTool() {
        return this.getAPI().getMessageTool();
    }

    public GlobalSearchPluginApi getSearchApi() {
        return this.getAPI().getSearchApi();
    }

    public boolean canCreateWiki() {
        return this.getAPI().canCreateWiki();
    }

    public boolean canEditWiki() {
        return this.getAPI().canEditWiki();
    }

    public boolean canDeleteWiki() {
        return this.getAPI().canDeleteWiki();
    }

    public int createNewWiki(String wikiName, String templateWiki, String pkgName, XWikiServer wikiXObjectDocument, boolean failOnExist) throws XWikiException {
        return this.getAPI().createNewWiki(wikiName, templateWiki, pkgName, wikiXObjectDocument, failOnExist);
    }

    public int deleteWiki(String wikiName, boolean deleteDatabase) throws XWikiException {
        return this.getAPI().deleteWiki(wikiName, deleteDatabase);
    }

    public int deleteWiki(String wikiName) throws XWikiException {
        return this.getAPI().deleteWiki(wikiName);
    }

    public int deleteWikiAlias(String wikiName, int objectId) throws XWikiException {
        return this.getAPI().deleteWikiAlias(wikiName, objectId);
    }

    public Wiki getWikiFromName(String wikiName) throws XWikiException {
        return this.getAPI().getWikiFromName(wikiName);
    }

    public List<Wiki> getAllWikis() throws XWikiException {
        return this.getAPI().getAllWikis();
    }

    public Wiki getWikiFromDocumentName(String documentFullName) throws XWikiException {
        return this.getAPI().getWikiFromDocumentName(documentFullName);
    }

    public XWikiServer getWikiDocument(String wikiName) throws XWikiException {
        return this.getAPI().getWikiDocument(wikiName);
    }

    public XWikiServer getWikiDocument(String wikiName, int objectId) throws XWikiException {
        return this.getAPI().getWikiDocument(wikiName, objectId);
    }

    public List<XWikiServer> getWikiDocumentList() throws XWikiException {
        return this.getAPI().getWikiDocumentList();
    }

    public XWikiServer createWikiDocument() throws XWikiException {
        return this.getAPI().createWikiDocument();
    }

    public boolean isWikiExist(String wikiName) {
        return this.getAPI().isWikiExist(wikiName);
    }

    public boolean isWikiExist(String wikiName, int objectId) {
        return this.getAPI().isWikiExist(wikiName, objectId);
    }

    public boolean isWikiNameAvailable(String wikiName) throws XWikiException {
        return this.getAPI().isWikiNameAvailable(wikiName);
    }

    public int setWikiVisibility(String wikiName, String visibility) throws XWikiException {
        return this.getAPI().setWikiVisibility(wikiName, visibility);
    }

    public int setWikiVisibility(String wikiName, int objectId, String visibility) throws XWikiException {
        return this.getAPI().setWikiVisibility(wikiName, objectId, visibility);
    }

    public int setIsWikiTemplate(String wikiName, boolean isWikiTemplate) throws XWikiException {
        return this.getAPI().setIsWikiTemplate(wikiName, isWikiTemplate);
    }

    public int createWikiTemplate(String templateName, String templateDescription, String packageName) throws XWikiException {
        return this.getAPI().createWikiTemplate(templateName, templateDescription, packageName);
    }

    public XWikiServer getWikiTemplateDocument(String wikiName) throws XWikiException {
        return this.getAPI().getWikiTemplateDocument(wikiName);
    }

    public XWikiServer getWikiTemplateDocument(String wikiName, int objectId) throws XWikiException {
        return this.getAPI().getWikiTemplateDocument(wikiName, objectId);
    }

    public List<XWikiServer> getWikiTemplateList() throws XWikiException {
        return this.getAPI().getWikiTemplateList();
    }

    public WikiManagerPlugin getInternalPlugin() {
        return (WikiManagerPlugin)this.getAPI().getInternalPlugin();
    }

    public boolean hasProgrammingRights() {
        return this.getAPI().hasProgrammingRights();
    }

    public boolean hasAdminRights() {
        return this.getAPI().hasAdminRights();
    }

    public boolean hasWikiAdminRights() {
        return this.getAPI().hasWikiAdminRights();
    }

    public boolean hasAccessLevel(String right, String docname) throws XWikiException {
        return this.getAPI().hasAccessLevel(right, docname);
    }
}

