/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.manager.rest.internal.resources;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPlugin;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPluginApi;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.manager.rest.resources.WikiManagerResource;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;

@Component(value="org.xwiki.manager.rest.internal.resources.WikiManagerResourceImpl")
@Path(value="/wikimanager")
public class WikiManagerResourceImpl
extends XWikiResource
implements WikiManagerResource {
    @POST
    public Response createWiki(@QueryParam(value="template") String template, Wiki wiki) throws XWikiRestException {
        XWikiContext xwikiContext = Utils.getXWikiContext((ComponentManager)this.componentManager);
        WikiManagerPlugin wikiManagerPlugin = new WikiManagerPlugin("wikimanager", WikiManagerPlugin.class.getName(), xwikiContext);
        wikiManagerPlugin.init(xwikiContext);
        WikiManagerPluginApi wikiManager = (WikiManagerPluginApi)wikiManagerPlugin.getPluginApi((XWikiPluginInterface)wikiManagerPlugin, xwikiContext);
        try {
            XWikiServer wikiServer = wikiManager.createWikiDocument();
            if (wiki.getId() == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Wiki id must be specified").build());
            }
            wikiServer.setServer(wiki.getId());
            if (wiki.getOwner() != null) {
                wikiServer.setOwner(wiki.getOwner());
            } else {
                wikiServer.setOwner(xwikiContext.getUser());
            }
            wikiServer.setWikiPrettyName(wiki.getName());
            wikiServer.setDescription(wiki.getDescription());
            int resultCode = wikiManager.createNewWiki(wiki.getId(), template, null, wikiServer, true);
            switch (resultCode) {
                case -1: {
                    break;
                }
                case 50033: {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)String.format("Wiki '%s' already exists", wiki.getId())).build());
                }
                default: {
                    throw new WebApplicationException(Response.serverError().entity((Object)String.format("Error creating wiki (Error number %d)", resultCode)).build());
                }
            }
            Wiki result = WikiManagerResourceImpl.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wiki.getId(), wiki.getOwner(), wiki.getDescription());
            Link home = this.objectFactory.createLink();
            home.setRel("http://www.xwiki.org/rel/home");
            home.setHref(wikiServer.getHomePageUrl().toString());
            result.getLinks().add(home);
            return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(WikiResource.class).build(new Object[]{wiki.getId()})).entity((Object)result).build();
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public static Wiki createWiki(ObjectFactory objectFactory, URI baseUri, String wikiName, String owner, String description) {
        Wiki wiki = objectFactory.createWiki().withId(wikiName).withName(wikiName).withOwner(owner).withDescription(description);
        String spacesUri = UriBuilder.fromUri((URI)baseUri).path(SpacesResource.class).build(new Object[]{wikiName}).toString();
        Link spacesLink = objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = UriBuilder.fromUri((URI)baseUri).path(ClassesResource.class).build(new Object[]{wikiName}).toString();
        Link classesLink = objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = UriBuilder.fromUri((URI)baseUri).path(ModificationsResource.class).build(new Object[]{wikiName}).toString();
        Link modificationsLink = objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = UriBuilder.fromUri((URI)baseUri).path(WikiSearchResource.class).build(new Object[]{wikiName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        String queryUri = UriBuilder.fromUri((URI)baseUri).path(WikiSearchQueryResource.class).build(new Object[]{wikiName}).toString();
        Link queryLink = objectFactory.createLink();
        queryLink.setHref(queryUri);
        queryLink.setRel("http://www.xwiki.org/rel/query");
        wiki.getLinks().add(queryLink);
        return wiki;
    }
}

