/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManager;
import org.xwiki.wiki.provisioning.WikiProvisioningJob;
import org.xwiki.wiki.rest.WikiManagerREST;
import org.xwiki.wiki.template.WikiTemplateManager;

@Component
@Named(value="org.xwiki.wiki.rest.internal.DefaultWikiManagerREST")
public class DefaultWikiManagerREST
extends XWikiResource
implements WikiManagerREST {
    @Inject
    private WikiManager wikiManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private WikiTemplateManager wikiTemplateManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @POST
    public Response createWiki(@QueryParam(value="template") String template, Wiki wiki) throws XWikiRestException {
        XWikiContext xcontext = this.getXWikiContext();
        WikiDescriptor descriptor = null;
        try {
            String ownerId = wiki.getOwner();
            if (ownerId == null) {
                ownerId = (String)this.entityReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]);
            }
            descriptor = this.wikiManager.create(wiki.getId(), wiki.getId(), ownerId, true);
            descriptor.setPrettyName(wiki.getName());
            descriptor.setDescription(wiki.getDescription());
            this.wikiDescriptorManager.saveDescriptor(descriptor);
            if (template != null) {
                WikiProvisioningJob job = this.wikiTemplateManager.applyTemplate(descriptor.getId(), template);
                job.join();
            }
            Wiki result = DefaultWikiManagerREST.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wiki.getId(), wiki.getOwner(), wiki.getDescription());
            Link home = this.objectFactory.createLink();
            home.setRel("http://www.xwiki.org/rel/home");
            home.setHref(xcontext.getWiki().getURL(descriptor.getMainPageReference(), "view", xcontext));
            result.getLinks().add(home);
            return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(WikiResource.class).build(new Object[]{wiki.getId()})).entity((Object)result).build();
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public static Wiki createWiki(ObjectFactory objectFactory, URI baseUri, String wikiName, String owner, String description) {
        Wiki wiki = objectFactory.createWiki().withId(wikiName).withName(wikiName).withOwner(owner).withDescription(description);
        String spacesUri = UriBuilder.fromUri((URI)baseUri).path(SpacesResource.class).build(new Object[]{wikiName}).toString();
        Link spacesLink = objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = UriBuilder.fromUri((URI)baseUri).path(ClassesResource.class).build(new Object[]{wikiName}).toString();
        Link classesLink = objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = UriBuilder.fromUri((URI)baseUri).path(ModificationsResource.class).build(new Object[]{wikiName}).toString();
        Link modificationsLink = objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = UriBuilder.fromUri((URI)baseUri).path(WikiSearchResource.class).build(new Object[]{wikiName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        String queryUri = UriBuilder.fromUri((URI)baseUri).path(WikiSearchQueryResource.class).build(new Object[]{wikiName}).toString();
        Link queryLink = objectFactory.createLink();
        queryLink.setHref(queryUri);
        queryLink.setRel("http://www.xwiki.org/rel/query");
        wiki.getLinks().add(queryLink);
        return wiki;
    }
}

