/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="WikiManagerCode.WikiTemplateClass")
@Singleton
public class WikiTemplateClassDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "WikiTemplateClass";
    public static final String DOCUMENT_SPACE = "WikiManager";
    public static final EntityReference SERVER_CLASS = new EntityReference("WikiTemplateClass", EntityType.DOCUMENT, new EntityReference("WikiManager", EntityType.SPACE));
    public static final String FIELD_ISWIKITEMPLATE = "iswikitemplate";
    public static final String FIELDPN_ISWIKITEMPLATE = "Template";
    public static final String FIELDDT_ISWIKITEMPLATE = "checkbox";
    public static final Boolean DEFAULT_ISWIKITEMPLATE = Boolean.FALSE;

    public WikiTemplateClassDocumentInitializer() {
        super(DOCUMENT_SPACE, DOCUMENT_NAME);
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        BaseClass baseClass = document.getXClass();
        needsUpdate |= baseClass.addBooleanField(FIELD_ISWIKITEMPLATE, FIELDPN_ISWIKITEMPLATE, FIELDDT_ISWIKITEMPLATE);
        needsUpdate |= this.updateBooleanClassDefaultValue(baseClass, FIELD_ISWIKITEMPLATE, DEFAULT_ISWIKITEMPLATE);
        if (!document.isHidden().booleanValue()) {
            document.setHidden(Boolean.valueOf(true));
            needsUpdate = true;
        }
        if (document.isNew()) {
            needsUpdate |= this.setClassDocumentFields(document, "Wiki Template Class");
            document.setContent(document.getContent() + "\n\nClass that represents the wiki descriptor property group" + " for the template feature.");
        }
        return needsUpdate;
    }
}

