/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.internal.migration;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="R54000WikiTemplateMigration")
@Singleton
public class WikiTemplateMigration
extends AbstractHibernateDataMigration {
    private static final String OLD_TEMPLATE_PROPERTY = "iswikitemplate";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public String getDescription() {
        return "http://jira.xwiki.org/browse/XWIKI-9934";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(54000);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return this.wikiDescriptorManager.getCurrentWikiId().equals(this.wikiDescriptorManager.getMainWikiId());
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        DocumentReference templateClassReference = new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), "WikiManager", "WikiTemplateClass");
        DocumentReference descriptorClassReference = new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), "XWiki", "XWikiServerClass");
        DocumentReference superAdmin = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), "XWiki", "superadmin");
        try {
            String statement = "select distinct doc.fullName from Document doc, doc.object(XWiki.XWikiServerClass) as obj";
            Query query = this.queryManager.createQuery(statement, "xwql");
            List results = query.execute();
            for (String wikiPage : results) {
                XWikiDocument document = xwiki.getDocument(this.documentReferenceResolver.resolve((Object)wikiPage, new Object[0]), context);
                BaseObject descriptorObject = document.getXObject(descriptorClassReference);
                int isTemplate = descriptorObject.getIntValue(OLD_TEMPLATE_PROPERTY, 0);
                descriptorObject.removeField(OLD_TEMPLATE_PROPERTY);
                BaseObject object = document.getXObject(templateClassReference, true, context);
                isTemplate = object.getIntValue(OLD_TEMPLATE_PROPERTY, isTemplate);
                object.setIntValue(OLD_TEMPLATE_PROPERTY, isTemplate);
                document.setAuthorReference(superAdmin);
                xwiki.saveDocument(document, "[UPGRADE] Upgrade the template section.", context);
            }
        }
        catch (QueryException e) {
            throw new DataMigrationException("Failed to get the list of all existing descriptors.", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Failed to upgrade a wiki descriptor.", (Throwable)e);
        }
    }
}

