/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.script;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.user.MemberCandidacy;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;
import org.xwiki.wiki.user.script.WikiUserManagerScriptServiceException;

@Component
@Named(value="wiki.user")
@Singleton
public class WikiUserManagerScriptService
implements ScriptService {
    private static final String WIKIUSERERROR_KEY = "scriptservice.wiki.user.error";
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Execution execution;

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(WIKIUSERERROR_KEY);
    }

    private void setLastError(Exception e) {
        this.execution.getContext().setProperty(WIKIUSERERROR_KEY, (Object)e);
    }

    public UserScope getUserScope() {
        return this.getUserScope(this.wikiDescriptorManager.getCurrentWikiId());
    }

    public UserScope getUserScope(String wikiId) {
        try {
            return this.wikiUserManager.getUserScope(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    private void checkRights(String wikiId) throws AccessDeniedException {
        this.checkRights(wikiId, null);
    }

    private void checkRights(String wikiId, DocumentReference user) throws AccessDeniedException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        this.authorizationManager.checkAccess(Right.ADMIN, context.getDoc().getAuthorReference(), (EntityReference)context.getDoc().getDocumentReference());
        if (user != null && user.equals((Object)context.getUserReference())) {
            return;
        }
        this.authorizationManager.checkAccess(Right.ADMIN, context.getUserReference(), (EntityReference)new WikiReference(wikiId));
    }

    private void checkRights(MemberCandidacy candidacy) throws AccessDeniedException {
        this.checkRights(candidacy.getWikiId(), this.documentReferenceResolver.resolve((Object)candidacy.getUserId(), new Object[0]));
    }

    public boolean setUserScope(String wikiId, String scope) {
        try {
            this.checkRights(wikiId);
            this.wikiUserManager.setUserScope(wikiId, UserScope.valueOf((String)scope.toUpperCase()));
        }
        catch (IllegalArgumentException | AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
        return true;
    }

    public MembershipType getMembershipType() {
        return this.getMembershipType(this.wikiDescriptorManager.getCurrentWikiId());
    }

    public MembershipType getMembershipType(String wikiId) {
        try {
            return this.wikiUserManager.getMembershipType(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean setMembershipType(String wikiId, String type) {
        try {
            this.checkRights(wikiId);
            this.wikiUserManager.setMembershipType(wikiId, MembershipType.valueOf((String)type.toUpperCase()));
        }
        catch (IllegalArgumentException | AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
        return true;
    }

    public Collection<String> getMembers(String wikiId) {
        try {
            return this.wikiUserManager.getMembers(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public Boolean isMember(String userId, String wikiId) {
        try {
            return this.wikiUserManager.isMember(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean addMember(String userId, String wikiId) {
        try {
            this.checkRights(wikiId);
            this.wikiUserManager.addMember(userId, wikiId);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
        return true;
    }

    public boolean addMembers(Collection<String> userIds, String wikiId) {
        try {
            this.checkRights(wikiId);
            this.wikiUserManager.addMembers(userIds, wikiId);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
        return true;
    }

    public boolean removeMember(String userId, String wikiId) {
        try {
            this.checkRights(wikiId);
            this.wikiUserManager.removeMember(userId, wikiId);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
        return true;
    }

    private boolean canSeeCandidacy(MemberCandidacy candidacy) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference candidacyUser = this.documentReferenceResolver.resolve((Object)candidacy.getUserId(), new Object[0]);
        if (context.getUserReference().equals((Object)candidacyUser)) {
            candidacy.setAdminPrivateComment(null);
            return true;
        }
        return this.authorizationManager.hasAccess(Right.ADMIN, context.getUserReference(), (EntityReference)new WikiReference(candidacy.getWikiId()));
    }

    public MemberCandidacy getCandidacy(String wikiId, int candidacyId) {
        MemberCandidacy candidacy = null;
        try {
            candidacy = this.wikiUserManager.getCandidacy(wikiId, candidacyId);
            if (!this.canSeeCandidacy(candidacy)) {
                this.setLastError(new WikiUserManagerScriptServiceException("You are not allowed to see this candidacy."));
                candidacy = null;
            }
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        return candidacy;
    }

    private Collection<MemberCandidacy> filterAuthorizedCandidacies(Collection<MemberCandidacy> candidacies) {
        ArrayList<MemberCandidacy> authorizedCandidacies = new ArrayList<MemberCandidacy>();
        for (MemberCandidacy candidacy : candidacies) {
            if (!this.canSeeCandidacy(candidacy)) continue;
            authorizedCandidacies.add(candidacy);
        }
        return authorizedCandidacies;
    }

    public Collection<MemberCandidacy> getAllInvitations(String wikiId) {
        try {
            Collection candidacies = this.wikiUserManager.getAllInvitations(wikiId);
            return this.filterAuthorizedCandidacies(candidacies);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public Boolean hasPendingInvitation(DocumentReference user, String wikiId) {
        if (user == null) {
            return false;
        }
        try {
            this.checkRights(wikiId, user);
            return this.wikiUserManager.hasPendingInvitation(user, wikiId);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return null;
        }
    }

    public Boolean hasPendingRequest(DocumentReference user, String wikiId) {
        if (user == null) {
            return false;
        }
        try {
            this.checkRights(wikiId, user);
            return this.wikiUserManager.hasPendingRequest(user, wikiId);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return null;
        }
    }

    public Collection<MemberCandidacy> getAllRequests(String wikiId) {
        try {
            Collection candidacies = this.wikiUserManager.getAllRequests(wikiId);
            return this.filterAuthorizedCandidacies(candidacies);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean join(String userId, String wikiId) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference candidacyUser = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        if (!context.getUserReference().equals((Object)candidacyUser)) {
            this.setLastError((Exception)((Object)new WikiUserManagerException(String.format("User [%s] cannot call $services.wiki.user.join() with an other userId.", context.getUserReference()))));
            return false;
        }
        try {
            this.wikiUserManager.join(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean leave(String userId, String wikiId) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference candidacyUser = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        if (!context.getUserReference().equals((Object)candidacyUser)) {
            this.setLastError((Exception)((Object)new WikiUserManagerException(String.format("User [%s] cannot call $services.wiki.user.leave() with an other userId.", context.getUserReference()))));
            return false;
        }
        try {
            this.wikiUserManager.leave(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public MemberCandidacy askToJoin(String userId, String wikiId, String message) {
        try {
            this.checkRights(wikiId, this.documentReferenceResolver.resolve((Object)userId, new Object[0]));
            return this.wikiUserManager.askToJoin(userId, wikiId, message);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return null;
        }
    }

    public boolean acceptRequest(MemberCandidacy request, String message, String privateComment) {
        try {
            this.checkRights(request);
            this.wikiUserManager.acceptRequest(request, message, privateComment);
            return true;
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
    }

    public boolean refuseRequest(MemberCandidacy request, String message, String privateComment) {
        try {
            this.checkRights(request);
            this.wikiUserManager.refuseRequest(request, message, privateComment);
            return true;
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
    }

    public boolean cancelCandidacy(MemberCandidacy candidacy) {
        try {
            this.checkRights(candidacy);
            this.wikiUserManager.cancelCandidacy(candidacy);
            return true;
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
    }

    public MemberCandidacy invite(String userId, String wikiId, String message) {
        try {
            this.checkRights(wikiId);
            return this.wikiUserManager.invite(userId, wikiId, message);
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return null;
        }
    }

    public boolean acceptInvitation(MemberCandidacy invitation, String message) {
        try {
            this.checkRights(invitation);
            this.wikiUserManager.acceptInvitation(invitation, message);
            return true;
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
    }

    public boolean refuseInvitation(MemberCandidacy invitation, String message) {
        try {
            this.checkRights(invitation);
            this.wikiUserManager.refuseInvitation(invitation, message);
            return true;
        }
        catch (AccessDeniedException | WikiUserManagerException e) {
            this.setLastError((Exception)e);
            return false;
        }
    }
}

