/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.descriptor.WikiStreamDescriptor;
import org.xwiki.wikistream.descriptor.WikiStreamPropertyDescriptor;

@Unstable
public abstract class AbstractWikiStreamDescriptor
implements WikiStreamDescriptor {
    protected String name;
    protected String description;
    protected Map<String, WikiStreamPropertyDescriptor<?>> parameterDescriptorMap = new LinkedHashMap();

    public AbstractWikiStreamDescriptor(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public <T> WikiStreamPropertyDescriptor<T> getPropertyDescriptor(String propertyName) {
        return this.parameterDescriptorMap.get(propertyName);
    }

    @Override
    public Collection<WikiStreamPropertyDescriptor<?>> getProperties() {
        return Collections.unmodifiableCollection(this.parameterDescriptorMap.values());
    }
}

