/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.internal.output;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.internal.AbstractBeanWikiStreamFactory;
import org.xwiki.wikistream.internal.input.BeanInputWikiStream;
import org.xwiki.wikistream.internal.output.BeanOutputWikiStream;
import org.xwiki.wikistream.output.BeanOutputWikiStreamFactory;
import org.xwiki.wikistream.output.OutputWikiStream;
import org.xwiki.wikistream.type.WikiStreamType;

public abstract class AbstractBeanOutputWikiStreamFactory<P, F>
extends AbstractBeanWikiStreamFactory<P>
implements BeanOutputWikiStreamFactory<P> {
    @Inject
    private ComponentManager componentManager;
    private List<Class<?>> filerInterfaces;

    public AbstractBeanOutputWikiStreamFactory(WikiStreamType type) {
        super(type);
    }

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanOutputWikiStreamFactory.class, this.getClass());
        this.filerInterfaces = Arrays.asList(ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]));
    }

    @Override
    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        return this.filerInterfaces;
    }

    @Override
    public OutputWikiStream createOutputWikiStream(Map<String, Object> properties) throws WikiStreamException {
        return this.createOutputWikiStream(this.createPropertiesBean(properties));
    }

    @Override
    public BeanOutputWikiStream<P> createOutputWikiStream(P properties) throws WikiStreamException {
        BeanOutputWikiStream inputWikiStream;
        try {
            inputWikiStream = (BeanOutputWikiStream)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, BeanOutputWikiStream.class, new Type[]{this.getPropertiesBeanClass()}), this.getType().serialize());
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException(String.format("Failed to get instance of [%s] for type [%s]", BeanInputWikiStream.class, this.getType()), e);
        }
        inputWikiStream.setProperties(properties);
        return inputWikiStream;
    }
}

